/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStoreMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class KeyValueBasedTimelineStore
extends AbstractService
implements TimelineStore {
    protected TimelineStoreMapAdapter<EntityIdentifier, TimelineEntity> entities;
    protected TimelineStoreMapAdapter<EntityIdentifier, Long> entityInsertTimes;
    protected TimelineStoreMapAdapter<String, TimelineDomain> domainById;
    protected TimelineStoreMapAdapter<String, Set<TimelineDomain>> domainsByOwner;
    private boolean serviceStopped = false;
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueBasedTimelineStore.class);

    public KeyValueBasedTimelineStore() {
        super(KeyValueBasedTimelineStore.class.getName());
    }

    public KeyValueBasedTimelineStore(String name) {
        super(name);
    }

    public synchronized boolean getServiceStopped() {
        return this.serviceStopped;
    }

    protected synchronized void serviceStop() throws Exception {
        this.serviceStopped = true;
        super.serviceStop();
    }

    @Override
    public synchronized TimelineEntities getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, String fromId, Long fromTs, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields, TimelineDataManager.CheckAcl checkAcl) throws IOException {
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return null;
        }
        if (limit == null) {
            limit = 100L;
        }
        if (windowStart == null) {
            windowStart = Long.MIN_VALUE;
        }
        if (windowEnd == null) {
            windowEnd = Long.MAX_VALUE;
        }
        if (fields == null) {
            fields = EnumSet.allOf(TimelineReader.Field.class);
        }
        Iterator<TimelineEntity> entityIterator = null;
        if (fromId != null) {
            TimelineEntity firstEntity = this.entities.get(new EntityIdentifier(fromId, entityType));
            if (firstEntity == null) {
                return new TimelineEntities();
            }
            entityIterator = this.entities.valueSetIterator(firstEntity);
        }
        if (entityIterator == null) {
            entityIterator = this.entities.valueSetIterator();
        }
        ArrayList<TimelineEntity> entitiesSelected = new ArrayList<TimelineEntity>();
        while (entityIterator.hasNext()) {
            TimelineEntity entity = entityIterator.next();
            if ((long)entitiesSelected.size() >= limit) break;
            if (!entity.getEntityType().equals(entityType) || entity.getStartTime() <= windowStart || entity.getStartTime() > windowEnd || fromTs != null && this.entityInsertTimes.get(new EntityIdentifier(entity.getEntityId(), entity.getEntityType())) > fromTs || primaryFilter != null && !KeyValueBasedTimelineStoreUtils.matchPrimaryFilter(entity.getPrimaryFilters(), primaryFilter)) continue;
            if (secondaryFilters != null) {
                boolean flag = true;
                for (NameValuePair secondaryFilter : secondaryFilters) {
                    if (secondaryFilter == null || KeyValueBasedTimelineStoreUtils.matchPrimaryFilter(entity.getPrimaryFilters(), secondaryFilter) || KeyValueBasedTimelineStoreUtils.matchFilter(entity.getOtherInfo(), secondaryFilter)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
            }
            if (entity.getDomainId() == null) {
                entity.setDomainId("DEFAULT");
            }
            if (checkAcl != null && !checkAcl.check(entity)) continue;
            entitiesSelected.add(entity);
        }
        ArrayList<TimelineEntity> entitiesToReturn = new ArrayList<TimelineEntity>();
        for (TimelineEntity entitySelected : entitiesSelected) {
            entitiesToReturn.add(KeyValueBasedTimelineStoreUtils.maskFields(entitySelected, fields));
        }
        Collections.sort(entitiesToReturn);
        TimelineEntities entitiesWrapper = new TimelineEntities();
        entitiesWrapper.setEntities(entitiesToReturn);
        return entitiesWrapper;
    }

    @Override
    public synchronized TimelineEntity getEntity(String entityId, String entityType, EnumSet<TimelineReader.Field> fieldsToRetrieve) {
        TimelineEntity entity;
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return null;
        }
        if (fieldsToRetrieve == null) {
            fieldsToRetrieve = EnumSet.allOf(TimelineReader.Field.class);
        }
        if ((entity = this.entities.get(new EntityIdentifier(entityId, entityType))) == null) {
            return null;
        }
        return KeyValueBasedTimelineStoreUtils.maskFields(entity, fieldsToRetrieve);
    }

    @Override
    public synchronized TimelineEvents getEntityTimelines(String entityType, SortedSet<String> entityIds, Long limit, Long windowStart, Long windowEnd, Set<String> eventTypes) {
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return null;
        }
        TimelineEvents allEvents = new TimelineEvents();
        if (entityIds == null) {
            return allEvents;
        }
        if (limit == null) {
            limit = 100L;
        }
        if (windowStart == null) {
            windowStart = Long.MIN_VALUE;
        }
        if (windowEnd == null) {
            windowEnd = Long.MAX_VALUE;
        }
        for (String entityId : entityIds) {
            EntityIdentifier entityID = new EntityIdentifier(entityId, entityType);
            TimelineEntity entity = this.entities.get(entityID);
            if (entity == null) continue;
            TimelineEvents.EventsOfOneEntity events = new TimelineEvents.EventsOfOneEntity();
            events.setEntityId(entityId);
            events.setEntityType(entityType);
            for (TimelineEvent event : entity.getEvents()) {
                if ((long)events.getEvents().size() >= limit) break;
                if (event.getTimestamp() <= windowStart || event.getTimestamp() > windowEnd || eventTypes != null && !eventTypes.contains(event.getEventType())) continue;
                events.addEvent(event);
            }
            allEvents.addEvent(events);
        }
        return allEvents;
    }

    @Override
    public TimelineDomain getDomain(String domainId) throws IOException {
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return null;
        }
        TimelineDomain domain = this.domainById.get(domainId);
        if (domain == null) {
            return null;
        }
        return KeyValueBasedTimelineStoreUtils.createTimelineDomain(domain.getId(), domain.getDescription(), domain.getOwner(), domain.getReaders(), domain.getWriters(), domain.getCreatedTime(), domain.getModifiedTime());
    }

    @Override
    public TimelineDomains getDomains(String owner) throws IOException {
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return null;
        }
        ArrayList<TimelineDomain> domains = new ArrayList<TimelineDomain>();
        Set<TimelineDomain> domainsOfOneOwner = this.domainsByOwner.get(owner);
        if (domainsOfOneOwner == null) {
            return new TimelineDomains();
        }
        for (TimelineDomain domain : this.domainsByOwner.get(owner)) {
            TimelineDomain domainToReturn = KeyValueBasedTimelineStoreUtils.createTimelineDomain(domain.getId(), domain.getDescription(), domain.getOwner(), domain.getReaders(), domain.getWriters(), domain.getCreatedTime(), domain.getModifiedTime());
            domains.add(domainToReturn);
        }
        Collections.sort(domains, new Comparator<TimelineDomain>(){

            @Override
            public int compare(TimelineDomain domain1, TimelineDomain domain2) {
                int result = domain2.getCreatedTime().compareTo(domain1.getCreatedTime());
                if (result == 0) {
                    return domain2.getModifiedTime().compareTo(domain1.getModifiedTime());
                }
                return result;
            }
        });
        TimelineDomains domainsToReturn = new TimelineDomains();
        domainsToReturn.addDomains(domains);
        return domainsToReturn;
    }

    @Override
    public synchronized TimelinePutResponse put(TimelineEntities data) {
        TimelinePutResponse response = new TimelinePutResponse();
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
            error.setErrorCode(2);
            response.addError(error);
            return response;
        }
        for (TimelineEntity entity : data.getEntities()) {
            TimelinePutResponse.TimelinePutError error;
            EntityIdentifier entityId = new EntityIdentifier(entity.getEntityId(), entity.getEntityType());
            TimelineEntity existingEntity = this.entities.get(entityId);
            boolean needsPut = false;
            if (existingEntity == null) {
                existingEntity = new TimelineEntity();
                existingEntity.setEntityId(entity.getEntityId());
                existingEntity.setEntityType(entity.getEntityType());
                existingEntity.setStartTime(entity.getStartTime());
                if (entity.getDomainId() == null || entity.getDomainId().length() == 0) {
                    error = new TimelinePutResponse.TimelinePutError();
                    error.setEntityId(entityId.getId());
                    error.setEntityType(entityId.getType());
                    error.setErrorCode(5);
                    response.addError(error);
                    continue;
                }
                existingEntity.setDomainId(entity.getDomainId());
                this.entityInsertTimes.put(entityId, System.currentTimeMillis());
                needsPut = true;
            }
            if (entity.getEvents() != null) {
                if (existingEntity.getEvents() == null) {
                    existingEntity.setEvents(entity.getEvents());
                } else {
                    existingEntity.addEvents(entity.getEvents());
                }
                Collections.sort(existingEntity.getEvents());
                needsPut = true;
            }
            if (existingEntity.getStartTime() == null) {
                if (existingEntity.getEvents() == null || existingEntity.getEvents().isEmpty()) {
                    error = new TimelinePutResponse.TimelinePutError();
                    error.setEntityId(entityId.getId());
                    error.setEntityType(entityId.getType());
                    error.setErrorCode(1);
                    response.addError(error);
                    this.entities.remove(entityId);
                    this.entityInsertTimes.remove(entityId);
                    continue;
                }
                Long min = Long.MAX_VALUE;
                for (TimelineEvent e : entity.getEvents()) {
                    if (min <= e.getTimestamp()) continue;
                    min = e.getTimestamp();
                }
                existingEntity.setStartTime(min);
                needsPut = true;
            }
            if (entity.getPrimaryFilters() != null) {
                if (existingEntity.getPrimaryFilters() == null) {
                    existingEntity.setPrimaryFilters(new HashMap());
                }
                for (Map.Entry pf : entity.getPrimaryFilters().entrySet()) {
                    for (Object pfo : (Set)pf.getValue()) {
                        existingEntity.addPrimaryFilter((String)pf.getKey(), KeyValueBasedTimelineStoreUtils.compactNumber(pfo));
                        needsPut = true;
                    }
                }
            }
            if (entity.getOtherInfo() != null) {
                if (existingEntity.getOtherInfo() == null) {
                    existingEntity.setOtherInfo(new HashMap());
                }
                for (Map.Entry info : entity.getOtherInfo().entrySet()) {
                    existingEntity.addOtherInfo((String)info.getKey(), KeyValueBasedTimelineStoreUtils.compactNumber(info.getValue()));
                    needsPut = true;
                }
            }
            if (needsPut) {
                this.entities.put(entityId, existingEntity);
            }
            if (entity.getRelatedEntities() == null) continue;
            for (Map.Entry partRelatedEntities : entity.getRelatedEntities().entrySet()) {
                if (partRelatedEntities == null) continue;
                for (String idStr : (Set)partRelatedEntities.getValue()) {
                    EntityIdentifier relatedEntityId = new EntityIdentifier(idStr, (String)partRelatedEntities.getKey());
                    TimelineEntity relatedEntity = this.entities.get(relatedEntityId);
                    if (relatedEntity != null) {
                        if (relatedEntity.getDomainId().equals(existingEntity.getDomainId())) {
                            relatedEntity.addRelatedEntity(existingEntity.getEntityType(), existingEntity.getEntityId());
                            this.entities.put(relatedEntityId, relatedEntity);
                            continue;
                        }
                        TimelinePutResponse.TimelinePutError error2 = new TimelinePutResponse.TimelinePutError();
                        error2.setEntityType(existingEntity.getEntityType());
                        error2.setEntityId(existingEntity.getEntityId());
                        error2.setErrorCode(6);
                        response.addError(error2);
                        continue;
                    }
                    relatedEntity = new TimelineEntity();
                    relatedEntity.setEntityId(relatedEntityId.getId());
                    relatedEntity.setEntityType(relatedEntityId.getType());
                    relatedEntity.setStartTime(existingEntity.getStartTime());
                    relatedEntity.addRelatedEntity(existingEntity.getEntityType(), existingEntity.getEntityId());
                    relatedEntity.setDomainId(existingEntity.getDomainId());
                    this.entities.put(relatedEntityId, relatedEntity);
                    this.entityInsertTimes.put(relatedEntityId, System.currentTimeMillis());
                }
            }
        }
        return response;
    }

    @Override
    public void put(TimelineDomain domain) throws IOException {
        if (this.getServiceStopped()) {
            LOG.info("Service stopped, return null for the storage");
            return;
        }
        TimelineDomain domainToReplace = this.domainById.get(domain.getId());
        Long currentTimestamp = System.currentTimeMillis();
        TimelineDomain domainToStore = KeyValueBasedTimelineStoreUtils.createTimelineDomain(domain.getId(), domain.getDescription(), domain.getOwner(), domain.getReaders(), domain.getWriters(), domainToReplace == null ? currentTimestamp : domainToReplace.getCreatedTime(), currentTimestamp);
        this.domainById.put(domainToStore.getId(), domainToStore);
        Set<TimelineDomain> domainsByOneOwner = this.domainsByOwner.get(domainToStore.getOwner());
        if (domainsByOneOwner == null) {
            domainsByOneOwner = new HashSet<TimelineDomain>();
            this.domainsByOwner.put(domainToStore.getOwner(), domainsByOneOwner);
        }
        if (domainToReplace != null) {
            domainsByOneOwner.remove(domainToReplace);
        }
        domainsByOneOwner.add(domainToStore);
    }

    private static class KeyValueBasedTimelineStoreUtils {
        private KeyValueBasedTimelineStoreUtils() {
        }

        static TimelineDomain createTimelineDomain(String id, String description, String owner, String readers, String writers, Long createdTime, Long modifiedTime) {
            TimelineDomain domainToStore = new TimelineDomain();
            domainToStore.setId(id);
            domainToStore.setDescription(description);
            domainToStore.setOwner(owner);
            domainToStore.setReaders(readers);
            domainToStore.setWriters(writers);
            domainToStore.setCreatedTime(createdTime);
            domainToStore.setModifiedTime(modifiedTime);
            return domainToStore;
        }

        static TimelineEntity maskFields(TimelineEntity entity, EnumSet<TimelineReader.Field> fields) {
            TimelineEntity entityToReturn = new TimelineEntity();
            entityToReturn.setEntityId(entity.getEntityId());
            entityToReturn.setEntityType(entity.getEntityType());
            entityToReturn.setStartTime(entity.getStartTime());
            entityToReturn.setDomainId(entity.getDomainId());
            if (fields.contains((Object)TimelineReader.Field.EVENTS)) {
                entityToReturn.addEvents(entity.getEvents());
            } else if (fields.contains((Object)TimelineReader.Field.LAST_EVENT_ONLY)) {
                entityToReturn.addEvent((TimelineEvent)entity.getEvents().get(0));
            } else {
                entityToReturn.setEvents(null);
            }
            if (fields.contains((Object)TimelineReader.Field.RELATED_ENTITIES)) {
                entityToReturn.addRelatedEntities(entity.getRelatedEntities());
            } else {
                entityToReturn.setRelatedEntities(null);
            }
            if (fields.contains((Object)TimelineReader.Field.PRIMARY_FILTERS)) {
                entityToReturn.addPrimaryFilters(entity.getPrimaryFilters());
            } else {
                entityToReturn.setPrimaryFilters(null);
            }
            if (fields.contains((Object)TimelineReader.Field.OTHER_INFO)) {
                entityToReturn.addOtherInfo(entity.getOtherInfo());
            } else {
                entityToReturn.setOtherInfo(null);
            }
            return entityToReturn;
        }

        static boolean matchFilter(Map<String, Object> tags, NameValuePair filter) {
            Object value = tags.get(filter.getName());
            if (value == null) {
                return false;
            }
            return value.equals(filter.getValue());
        }

        static boolean matchPrimaryFilter(Map<String, Set<Object>> tags, NameValuePair filter) {
            Set<Object> value = tags.get(filter.getName());
            if (value == null) {
                return false;
            }
            return value.contains(filter.getValue());
        }

        static Object compactNumber(Object o) {
            Long l;
            if (o instanceof Long && (l = (Long)o) >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return l.intValue();
            }
            return o;
        }
    }
}

