/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.hbase.master.balancer.AssignRegionAction;
import org.apache.hadoop.hbase.master.balancer.BalanceAction;
import org.apache.hadoop.hbase.master.balancer.BalancerClusterState;
import org.apache.hadoop.hbase.master.balancer.MoveRegionAction;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.SwapRegionsAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class CostFunction {
    private float multiplier = 0.0f;
    protected BalancerClusterState cluster;

    CostFunction() {
    }

    public static double getCostEpsilon(double cost) {
        return Math.ulp(cost);
    }

    boolean isNeeded() {
        return true;
    }

    float getMultiplier() {
        return this.multiplier;
    }

    void setMultiplier(float m) {
        this.multiplier = m;
    }

    void prepare(BalancerClusterState cluster) {
        this.cluster = cluster;
    }

    void postAction(BalanceAction action) {
        switch (action.getType()) {
            case NULL: {
                break;
            }
            case ASSIGN_REGION: {
                AssignRegionAction ar = (AssignRegionAction)action;
                this.regionMoved(ar.getRegion(), -1, ar.getServer());
                break;
            }
            case MOVE_REGION: {
                MoveRegionAction mra = (MoveRegionAction)action;
                this.regionMoved(mra.getRegion(), mra.getFromServer(), mra.getToServer());
                break;
            }
            case SWAP_REGIONS: {
                SwapRegionsAction a = (SwapRegionsAction)action;
                this.regionMoved(a.getFromRegion(), a.getFromServer(), a.getToServer());
                this.regionMoved(a.getToRegion(), a.getToServer(), a.getFromServer());
                break;
            }
            default: {
                throw new RuntimeException("Uknown action:" + (Object)((Object)action.getType()));
            }
        }
    }

    protected void regionMoved(int region, int oldServer, int newServer) {
    }

    protected abstract double cost();

    protected static double scale(double min, double max, double value) {
        double costEpsilon = CostFunction.getCostEpsilon(max);
        if (max <= min || value <= min || Math.abs(max - min) <= costEpsilon || Math.abs(value - min) <= costEpsilon) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(1.0, (value - min) / (max - min)));
    }

    public void updateWeight(double[] weights) {
        int n = StochasticLoadBalancer.GeneratorType.RANDOM.ordinal();
        weights[n] = weights[n] + this.cost();
    }
}

