/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.util;

import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DelayedUtil {
    public static final DelayedWithTimeout DELAYED_POISON = new DelayedWithTimeout(){

        @Override
        public long getTimeout() {
            return 0L;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(0L, DelayedUtil.getTimeout(o));
        }

        public boolean equals(Object other) {
            return this == other;
        }

        public int hashCode() {
            return Objects.hash(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(POISON)";
        }
    };

    private DelayedUtil() {
    }

    public static <E extends Delayed> E takeWithoutInterrupt(DelayQueue<E> queue, long timeout, TimeUnit timeUnit) {
        try {
            return (E)queue.poll(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static long getRemainingTime(TimeUnit resultUnit, long timeout) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        if (currentTime >= timeout) {
            return 0L;
        }
        return resultUnit.convert(timeout - currentTime, TimeUnit.MILLISECONDS);
    }

    public static int compareDelayed(Delayed o1, Delayed o2) {
        return Long.compare(DelayedUtil.getTimeout(o1), DelayedUtil.getTimeout(o2));
    }

    private static long getTimeout(Delayed o) {
        assert (o instanceof DelayedWithTimeout) : "expected DelayedWithTimeout instance, got " + o;
        return ((DelayedWithTimeout)o).getTimeout();
    }

    public static class DelayedContainerWithTimestamp<T>
    extends DelayedContainer<T> {
        private long timeout;

        public DelayedContainerWithTimestamp(T object, long timeout) {
            super(object);
            this.setTimeout(timeout);
        }

        @Override
        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }
    }

    public static abstract class DelayedContainer<T>
    extends DelayedObject {
        private final T object;

        public DelayedContainer(T object) {
            this.object = object;
        }

        public T getObject() {
            return this.object;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof DelayedContainer)) {
                return false;
            }
            return Objects.equals(this.getObject(), ((DelayedContainer)other).getObject());
        }

        public int hashCode() {
            return this.object != null ? this.object.hashCode() : 0;
        }

        @Override
        public String toString() {
            return "containedObject=" + this.getObject() + ", " + super.toString();
        }
    }

    public static abstract class DelayedObject
    implements DelayedWithTimeout {
        @Override
        public long getDelay(TimeUnit unit) {
            return DelayedUtil.getRemainingTime(unit, this.getTimeout());
        }

        @Override
        public int compareTo(Delayed other) {
            return DelayedUtil.compareDelayed(this, other);
        }

        public String toString() {
            long timeout = this.getTimeout();
            return "timeout=" + timeout + ", delay=" + this.getDelay(TimeUnit.MILLISECONDS);
        }
    }

    public static interface DelayedWithTimeout
    extends Delayed {
        public long getTimeout();
    }
}

