/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCreateTableNoRegionServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCreateTableNoRegionServer.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCreateTableNoRegionServer.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static byte[] FAMILY = Bytes.toBytes((String)"f1");
    private static CountDownLatch ARRIVE;
    private static CountDownLatch RESUME;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(StartMiniClusterOption.builder().masterClass(HMasterForTest.class).build());
        JmxCacheBuster.stop();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCreate() throws Exception {
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        Admin admin = UTIL.getAdmin();
        ARRIVE = new CountDownLatch(1);
        RESUME = new CountDownLatch(1);
        Future future = admin.createTableAsync(td);
        ARRIVE.await();
        UTIL.getMiniHBaseCluster().stopRegionServer(0).join();
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster().getServerManager().getOnlineServers().isEmpty());
        RESUME.countDown();
        Thread.sleep(10000L);
        for (Procedure proc : UTIL.getMiniHBaseCluster().getMaster().getProcedures()) {
            if (!(proc instanceof CreateTableProcedure) || proc.isFinished() || ((CreateTableProcedure)proc).getCurrentStateId() == 4) continue;
            LOG.warn("Create table procedure {} assigned regions without a region server!", (Object)proc);
        }
        UTIL.getMiniHBaseCluster().startRegionServer();
        future.get(30L, TimeUnit.SECONDS);
        try (Table table = UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setOperationTimeout(5000).build();){
            table.put(new Put(Bytes.toBytes((int)0)).addColumn(FAMILY, Bytes.toBytes((String)"q"), Bytes.toBytes((int)0)));
        }
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        private boolean isInAssignRegionsState() {
            try {
                for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
                    if (!e.getClassName().equals(CreateTableProcedure.class.getName()) || !e.getMethodName().equals("executeFromState")) continue;
                    for (Procedure proc : this.getProcedures()) {
                        if (!(proc instanceof CreateTableProcedure) || proc.isFinished() || ((CreateTableProcedure)proc).getCurrentStateId() != 4) continue;
                        return true;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return false;
        }

        public AssignmentManager getAssignmentManager() {
            if (ARRIVE != null && this.isInAssignRegionsState()) {
                ARRIVE.countDown();
                ARRIVE = null;
                try {
                    RESUME.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.getAssignmentManager();
        }
    }
}

