/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred.lib;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.mapred.lib.DynamicInputChunkContext;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicInputChunk<K, V> {
    private static Logger LOG = LoggerFactory.getLogger(DynamicInputChunk.class);
    private Path chunkFilePath;
    private SequenceFileRecordReader<K, V> reader;
    private SequenceFile.Writer writer;
    private DynamicInputChunkContext chunkContext;

    DynamicInputChunk(String chunkId, DynamicInputChunkContext chunkContext) throws IOException {
        this.chunkContext = chunkContext;
        this.chunkFilePath = new Path(chunkContext.getChunkRootPath(), chunkContext.getChunkFilePrefix() + chunkId);
        this.openForWrite();
    }

    private void openForWrite() throws IOException {
        this.writer = SequenceFile.createWriter((FileSystem)this.chunkContext.getFs(), (Configuration)this.chunkContext.getConfiguration(), (Path)this.chunkFilePath, Text.class, CopyListingFileStatus.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
    }

    public void write(Text key, CopyListingFileStatus value) throws IOException {
        this.writer.append((Writable)key, (Writable)value);
    }

    public void close() {
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.reader, this.writer});
    }

    public void assignTo(TaskID taskId) throws IOException {
        Path newPath = new Path(this.chunkContext.getChunkRootPath(), taskId.toString());
        if (!this.chunkContext.getFs().rename(this.chunkFilePath, newPath)) {
            LOG.warn(this.chunkFilePath + " could not be assigned to " + taskId);
        }
    }

    public DynamicInputChunk(Path chunkFilePath, TaskAttemptContext taskAttemptContext, DynamicInputChunkContext chunkContext) throws IOException, InterruptedException {
        this.chunkFilePath = chunkFilePath;
        this.chunkContext = chunkContext;
        this.openForRead(taskAttemptContext);
    }

    private void openForRead(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader = new SequenceFileRecordReader();
        this.reader.initialize((InputSplit)new FileSplit(this.chunkFilePath, 0L, DistCpUtils.getFileSize(this.chunkFilePath, this.chunkContext.getConfiguration()), null), taskAttemptContext);
    }

    public void release() throws IOException {
        this.close();
        if (!this.chunkContext.getFs().delete(this.chunkFilePath, false)) {
            LOG.error("Unable to release chunk at path: " + this.chunkFilePath);
            throw new IOException("Unable to release chunk at path: " + this.chunkFilePath);
        }
    }

    public Path getPath() {
        return this.chunkFilePath;
    }

    public SequenceFileRecordReader<K, V> getReader() {
        assert (this.reader != null) : "Reader un-initialized!";
        return this.reader;
    }
}

