/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.junit.Assert;
import org.junit.Test;

public class TestErasureCodingAddConfig {
    @Test
    public void testECAddPolicyConfigDisable() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.ec.userdefined.policy.allowed", false);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ErasureCodingPolicy newPolicy1 = new ErasureCodingPolicy(new ECSchema("rs", 5, 3), 0x100000);
            AddErasureCodingPolicyResponse[] response = fs.addErasureCodingPolicies(new ErasureCodingPolicy[]{newPolicy1});
            Assert.assertFalse((boolean)response[0].isSucceed());
            Assert.assertEquals((Object)"Addition of user defined erasure coding policy is disabled.", (Object)response[0].getErrorMsg());
        }
    }

    @Test
    public void testECAddPolicyConfigEnable() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.ec.userdefined.policy.allowed", true);
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();){
            DistributedFileSystem fs = cluster.getFileSystem();
            ErasureCodingPolicy newPolicy1 = new ErasureCodingPolicy(new ECSchema("rs", 5, 3), 0x100000);
            AddErasureCodingPolicyResponse[] response = fs.addErasureCodingPolicies(new ErasureCodingPolicy[]{newPolicy1});
            Assert.assertTrue((boolean)response[0].isSucceed());
            Assert.assertNull((Object)response[0].getErrorMsg());
        }
    }
}

