/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotDeletionGc;
import org.apache.hadoop.hdfs.server.namenode.snapshot.TestOrderedSnapshotDeletion;
import org.apache.hadoop.hdfs.util.Holder;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestOrderedSnapshotDeletionGc {
    private static final int GC_PERIOD = 10;
    private static final int NUM_DATANODES = 0;
    private MiniDFSCluster cluster;

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.snapshot.deletion.ordered", true);
        conf.setInt("dfs.namenode.snapshot.deletion.ordered.gc.period.ms", 10);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        this.cluster.waitActive();
        GenericTestUtils.setLogLevel((Logger)SnapshotDeletionGc.LOG, (Level)Level.TRACE);
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testSingleDir() throws Exception {
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        Path snapshottableDir = new Path("/dir");
        hdfs.mkdirs(snapshottableDir);
        hdfs.allowSnapshot(snapshottableDir);
        Path sub0 = new Path(snapshottableDir, "sub0");
        hdfs.mkdirs(sub0);
        Path s0path = hdfs.createSnapshot(snapshottableDir, "s0");
        Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(s0path, hdfs));
        Path sub1 = new Path(snapshottableDir, "sub1");
        hdfs.mkdirs(sub1);
        Path s1path = hdfs.createSnapshot(snapshottableDir, "s1");
        Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(s1path, hdfs));
        Path sub2 = new Path(snapshottableDir, "sub2");
        hdfs.mkdirs(sub2);
        Path s2path = hdfs.createSnapshot(snapshottableDir, "s2");
        Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(s2path, hdfs));
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s0path, this.cluster);
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s1path, this.cluster);
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s2path, this.cluster);
        hdfs.deleteSnapshot(snapshottableDir, "s2");
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s0path, this.cluster);
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s1path, this.cluster);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(s2path, snapshottableDir, this.cluster);
        Path s2pathNew = new Path(s2path.getParent(), TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, snapshottableDir, s2path.getName()));
        Assert.assertFalse((boolean)TestOrderedSnapshotDeletionGc.exist(s2path, hdfs));
        Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(s2pathNew, hdfs));
        Assert.assertFalse((boolean)s2path.equals((Object)s2pathNew));
        hdfs.deleteSnapshot(snapshottableDir, "s1");
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s0path, this.cluster);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(s1path, snapshottableDir, this.cluster);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(s2path, snapshottableDir, this.cluster);
        Path s1pathNew = new Path(s1path.getParent(), TestOrderedSnapshotDeletion.getDeletedSnapshotName(hdfs, snapshottableDir, s1path.getName()));
        Assert.assertFalse((boolean)TestOrderedSnapshotDeletionGc.exist(s1path, hdfs));
        Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(s1pathNew, hdfs));
        Assert.assertFalse((boolean)s1path.equals((Object)s1pathNew));
        Thread.sleep(100L);
        TestOrderedSnapshotDeletion.assertNotMarkedAsDeleted(s0path, this.cluster);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(s1path, snapshottableDir, this.cluster);
        TestOrderedSnapshotDeletion.assertMarkedAsDeleted(s2path, snapshottableDir, this.cluster);
        hdfs.deleteSnapshot(snapshottableDir, "s0");
        Assert.assertFalse((boolean)TestOrderedSnapshotDeletionGc.exist(s0path, hdfs));
        TestOrderedSnapshotDeletionGc.waitForGc(Arrays.asList(s1pathNew, s2pathNew), hdfs);
        TestOrderedSnapshotDeletionGc.doEditLogValidation(this.cluster, 5);
    }

    static void doEditLogValidation(MiniDFSCluster cluster, int editLogOpCount) throws Exception {
        FSNamesystem namesystem = cluster.getNamesystem();
        Configuration conf = cluster.getNameNode().getConf();
        FSImage fsimage = namesystem.getFSImage();
        Storage.StorageDirectory sd = (Storage.StorageDirectory)fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS).next();
        cluster.shutdown();
        File editFile = FSImageTestUtil.findLatestEditsLog(sd).getFile();
        Assert.assertTrue((String)("Should exist: " + editFile), (boolean)editFile.exists());
        EnumMap<FSEditLogOpCodes, Holder<Integer>> counts = FSImageTestUtil.countEditLogOpTypes(editFile);
        if (editLogOpCount > 0) {
            Assert.assertEquals((long)editLogOpCount, (long)((Integer)counts.get((Object)FSEditLogOpCodes.OP_DELETE_SNAPSHOT).held).intValue());
        }
        conf.setInt("dfs.namenode.snapshot.deletion.ordered.gc.period.ms", 1440000);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        Assert.assertEquals((long)0L, (long)cluster.getNamesystem().getSnapshotManager().getNumSnapshots());
    }

    static boolean exist(Path snapshotRoot, DistributedFileSystem hdfs) throws IOException {
        try {
            hdfs.getFileStatus(snapshotRoot);
            return true;
        }
        catch (FileNotFoundException ignored) {
            return false;
        }
    }

    static void waitForGc(List<Path> snapshotPaths, DistributedFileSystem hdfs) throws Exception {
        Iterator<Path> i = snapshotPaths.iterator();
        Path p = i.next();
        while (true) {
            if (!TestOrderedSnapshotDeletionGc.exist(p, hdfs)) {
                if (!i.hasNext()) {
                    return;
                }
                p = i.next();
                continue;
            }
            Thread.sleep(10L);
        }
    }

    @Test(timeout=60000L)
    public void testMultipleDirs() throws Exception {
        int numSnapshottables = 10;
        DistributedFileSystem hdfs = this.cluster.getFileSystem();
        ArrayList<Path> snapshottableDirs = new ArrayList<Path>();
        for (int i = 0; i < 10; ++i) {
            Path p = new Path("/dir" + i);
            snapshottableDirs.add(p);
            hdfs.mkdirs(p);
            hdfs.allowSnapshot(p);
        }
        Random random = new Random();
        ArrayList<Path> snapshotPaths = new ArrayList<Path>();
        for (Path s : snapshottableDirs) {
            int numSnapshots = random.nextInt(10) + 1;
            TestOrderedSnapshotDeletionGc.createSnapshots(s, numSnapshots, snapshotPaths, hdfs);
        }
        Collections.shuffle(snapshotPaths);
        for (Path p : snapshotPaths) {
            hdfs.deleteSnapshot(p.getParent().getParent(), p.getName());
        }
        TestOrderedSnapshotDeletionGc.waitForGc(snapshotPaths, hdfs);
        TestOrderedSnapshotDeletionGc.doEditLogValidation(this.cluster, -1);
    }

    static void createSnapshots(Path snapshottableDir, int numSnapshots, List<Path> snapshotPaths, DistributedFileSystem hdfs) throws IOException {
        for (int i = 0; i < numSnapshots; ++i) {
            Path sub = new Path(snapshottableDir, "sub" + i);
            hdfs.mkdirs(sub);
            Path p = hdfs.createSnapshot(snapshottableDir, "s" + i);
            snapshotPaths.add(p);
            Assert.assertTrue((boolean)TestOrderedSnapshotDeletionGc.exist(p, hdfs));
        }
    }
}

