/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RequestCountPerSecond {
    private long previousLastReportTimestamp;
    private long previousReadRequestCount;
    private long previousFilteredReadRequestCount;
    private long previousWriteRequestCount;
    private long readRequestCountPerSecond;
    private long filteredReadRequestCountPerSecond;
    private long writeRequestCountPerSecond;

    public void refresh(long lastReportTimestamp, long readRequestCount, long filteredReadRequestCount, long writeRequestCount) {
        if (this.previousLastReportTimestamp == 0L) {
            this.previousLastReportTimestamp = lastReportTimestamp;
            this.previousReadRequestCount = readRequestCount;
            this.previousFilteredReadRequestCount = filteredReadRequestCount;
            this.previousWriteRequestCount = writeRequestCount;
        } else if (this.previousLastReportTimestamp != lastReportTimestamp) {
            long delta = (lastReportTimestamp - this.previousLastReportTimestamp) / 1000L;
            if (delta < 1L) {
                delta = 1L;
            }
            this.readRequestCountPerSecond = (readRequestCount - this.previousReadRequestCount) / delta;
            this.filteredReadRequestCountPerSecond = (filteredReadRequestCount - this.previousFilteredReadRequestCount) / delta;
            this.writeRequestCountPerSecond = (writeRequestCount - this.previousWriteRequestCount) / delta;
            this.previousLastReportTimestamp = lastReportTimestamp;
            this.previousReadRequestCount = readRequestCount;
            this.previousFilteredReadRequestCount = filteredReadRequestCount;
            this.previousWriteRequestCount = writeRequestCount;
        }
    }

    public long getReadRequestCountPerSecond() {
        return this.readRequestCountPerSecond < 0L ? 0L : this.readRequestCountPerSecond;
    }

    public long getFilteredReadRequestCountPerSecond() {
        return this.filteredReadRequestCountPerSecond < 0L ? 0L : this.filteredReadRequestCountPerSecond;
    }

    public long getWriteRequestCountPerSecond() {
        return this.writeRequestCountPerSecond < 0L ? 0L : this.writeRequestCountPerSecond;
    }

    public long getRequestCountPerSecond() {
        return this.getReadRequestCountPerSecond() + this.getWriteRequestCountPerSecond();
    }
}

