/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncAdminModifyStoreFileTracker
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAdminModifyStoreFileTracker.class);
    private static final String SRC_IMPL = "hbase.store.file-tracker.migration.src.impl";
    private static final String DST_IMPL = "hbase.store.file-tracker.migration.dst.impl";

    private void verifyModifyTableResult(TableName tableName, byte[] family, byte[] qual, byte[] row, byte[] value, String sft) throws IOException {
        TableDescriptor td = (TableDescriptor)this.admin.getDescriptor(tableName).join();
        Assert.assertEquals((Object)sft, (Object)td.getValue("hbase.store.file-tracker.impl"));
        Assert.assertNull((Object)td.getValue(SRC_IMPL));
        Assert.assertNull((Object)td.getValue(DST_IMPL));
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Assert.assertArrayEquals((byte[])value, (byte[])table.get(new Get(row)).getValue(family, qual));
        }
    }

    @Test
    public void testModifyTableStoreFileTracker() throws IOException {
        byte[] family = Bytes.toBytes((String)"info");
        byte[] qual = Bytes.toBytes((String)"q");
        byte[] row = Bytes.toBytes((int)0);
        byte[] value = Bytes.toBytes((int)1);
        try (Table table = TEST_UTIL.createTable(this.tableName, family);){
            table.put(new Put(row).addColumn(family, qual, value));
        }
        this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyTableResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyTableResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        this.admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)((TableDescriptor)this.admin.getDescriptor(this.tableName).join())).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue(SRC_IMPL, StoreFileTrackerFactory.Trackers.FILE.name()).setValue(DST_IMPL, StoreFileTrackerFactory.Trackers.DEFAULT.name()).build()).join();
        this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyTableResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        this.admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)((TableDescriptor)this.admin.getDescriptor(this.tableName).join())).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setValue(SRC_IMPL, StoreFileTrackerFactory.Trackers.FILE.name()).setValue(DST_IMPL, StoreFileTrackerFactory.Trackers.DEFAULT.name()).build()).join();
        this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.DEFAULT.name()).join();
        this.verifyModifyTableResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.DEFAULT.name());
    }

    private void verifyModifyColumnFamilyResult(TableName tableName, byte[] family, byte[] qual, byte[] row, byte[] value, String sft) throws IOException {
        TableDescriptor td = (TableDescriptor)this.admin.getDescriptor(tableName).join();
        ColumnFamilyDescriptor cfd = td.getColumnFamily(family);
        Assert.assertEquals((Object)sft, (Object)cfd.getConfigurationValue("hbase.store.file-tracker.impl"));
        Assert.assertNull((Object)cfd.getConfigurationValue(SRC_IMPL));
        Assert.assertNull((Object)cfd.getConfigurationValue(DST_IMPL));
        Assert.assertNull((Object)cfd.getValue(SRC_IMPL));
        Assert.assertNull((Object)cfd.getValue(DST_IMPL));
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Assert.assertArrayEquals((byte[])value, (byte[])table.get(new Get(row)).getValue(family, qual));
        }
    }

    @Test
    public void testModifyColumnFamilyStoreFileTracker() throws IOException {
        byte[] family = Bytes.toBytes((String)"info");
        byte[] qual = Bytes.toBytes((String)"q");
        byte[] row = Bytes.toBytes((int)0);
        byte[] value = Bytes.toBytes((int)1);
        try (Table table = TEST_UTIL.createTable(this.tableName, family);){
            table.put(new Put(row).addColumn(family, qual, value));
        }
        this.admin.modifyColumnFamilyStoreFileTracker(this.tableName, family, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyColumnFamilyResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        this.admin.modifyColumnFamilyStoreFileTracker(this.tableName, family, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyColumnFamilyResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        TableDescriptor current = (TableDescriptor)this.admin.getDescriptor(this.tableName).join();
        this.admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)current).modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)current.getColumnFamily(family)).setConfiguration("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setConfiguration(SRC_IMPL, StoreFileTrackerFactory.Trackers.FILE.name()).setConfiguration(DST_IMPL, StoreFileTrackerFactory.Trackers.DEFAULT.name()).build()).build()).join();
        this.admin.modifyColumnFamilyStoreFileTracker(this.tableName, family, StoreFileTrackerFactory.Trackers.FILE.name()).join();
        this.verifyModifyColumnFamilyResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.FILE.name());
        current = (TableDescriptor)this.admin.getDescriptor(this.tableName).join();
        this.admin.modifyTable(TableDescriptorBuilder.newBuilder((TableDescriptor)current).modifyColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((ColumnFamilyDescriptor)current.getColumnFamily(family)).setConfiguration("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.MIGRATION.name()).setConfiguration(SRC_IMPL, StoreFileTrackerFactory.Trackers.FILE.name()).setConfiguration(DST_IMPL, StoreFileTrackerFactory.Trackers.DEFAULT.name()).build()).build()).join();
        this.admin.modifyColumnFamilyStoreFileTracker(this.tableName, family, StoreFileTrackerFactory.Trackers.DEFAULT.name()).join();
        this.verifyModifyColumnFamilyResult(this.tableName, family, qual, row, value, StoreFileTrackerFactory.Trackers.DEFAULT.name());
    }

    @Test
    public void testModifyStoreFileTrackerError() throws IOException {
        byte[] family = Bytes.toBytes((String)"info");
        TEST_UTIL.createTable(this.tableName, family).close();
        Assert.assertThrows(TableNotFoundException.class, () -> {
            Void cfr_ignored_0 = (Void)FutureUtils.get((Future)this.admin.modifyTableStoreFileTracker(TableName.valueOf((String)"whatever"), StoreFileTrackerFactory.Trackers.FILE.name()));
        });
        Assert.assertThrows(NoSuchColumnFamilyException.class, () -> {
            Void cfr_ignored_0 = (Void)FutureUtils.get((Future)this.admin.modifyColumnFamilyStoreFileTracker(this.tableName, Bytes.toBytes((String)"not_exists"), StoreFileTrackerFactory.Trackers.FILE.name()));
        });
        Assert.assertThrows(DoNotRetryIOException.class, () -> {
            Void cfr_ignored_0 = (Void)FutureUtils.get((Future)this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.MIGRATION.name()));
        });
        this.admin.disableTable(this.tableName).join();
        Assert.assertThrows(TableNotEnabledException.class, () -> {
            Void cfr_ignored_0 = (Void)FutureUtils.get((Future)this.admin.modifyTableStoreFileTracker(this.tableName, StoreFileTrackerFactory.Trackers.FILE.name()));
        });
    }
}

