/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerTableAccessor;
import org.apache.hadoop.hbase.regionserver.wal.WALEventTrackerListener;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestWALEventTrackerTableAccessor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALEventTrackerTableAccessor.class);

    @Test
    public void testRowKey() {
        String rsName = "test-region-server";
        String walName = "test-wal-0";
        long timeStamp = EnvironmentEdgeManager.currentTime();
        String walState = WALEventTrackerListener.WalState.ACTIVE.name();
        long walLength = 100L;
        WALEventTrackerPayload payload = new WALEventTrackerPayload(rsName, walName, timeStamp, walState, walLength);
        byte[] rowKeyBytes = WALEventTrackerTableAccessor.getRowKey((WALEventTrackerPayload)payload);
        String rowKeyBytesStr = Bytes.toString((byte[])rowKeyBytes);
        String[] fields = rowKeyBytesStr.split("_", -1);
        Assert.assertEquals((Object)walName, (Object)fields[0]);
        Assert.assertEquals((long)timeStamp, (long)Long.valueOf(fields[1]));
        Assert.assertEquals((Object)walState, (Object)fields[2]);
    }
}

