/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.compress.brotli;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.encoder.Encoder;
import com.aayushatharva.brotli4j.encoder.Encoders;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.compress.CanReinit;
import org.apache.hadoop.hbase.io.compress.CompressionUtil;
import org.apache.hadoop.hbase.io.compress.brotli.BrotliCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BrotliCompressor
implements CanReinit,
Compressor {
    protected ByteBuffer inBuf;
    protected ByteBuffer outBuf;
    protected int bufferSize;
    protected boolean finish;
    protected boolean finished;
    protected long bytesRead;
    protected long bytesWritten;
    protected Encoder.Parameters params;

    BrotliCompressor(int level, int window, int bufferSize) {
        this.bufferSize = bufferSize;
        this.inBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf = ByteBuffer.allocate(bufferSize);
        this.outBuf.position(bufferSize);
        this.params = new Encoder.Parameters();
        this.params.setQuality(level);
        this.params.setWindow(window);
    }

    public int compress(byte[] b, int off, int len) throws IOException {
        if (this.outBuf.hasRemaining()) {
            int remaining = this.outBuf.remaining();
            int n = Math.min(remaining, len);
            this.outBuf.get(b, off, n);
            return n;
        }
        if (this.finish) {
            if (this.inBuf.position() > 0) {
                ByteBuffer writeBuf;
                this.inBuf.flip();
                int uncompressed = this.inBuf.remaining();
                int needed = this.maxCompressedLength(uncompressed);
                boolean direct = false;
                if (len <= needed) {
                    direct = true;
                    writeBuf = ByteBuffer.wrap(b, off, len);
                } else {
                    if (this.outBuf.capacity() < needed) {
                        needed = CompressionUtil.roundInt2((int)needed);
                        this.outBuf = ByteBuffer.allocate(needed);
                    } else {
                        this.outBuf.clear();
                    }
                    writeBuf = this.outBuf;
                }
                int oldPos = writeBuf.position();
                Encoders.compress((ByteBuffer)this.inBuf, (ByteBuffer)writeBuf, (Encoder.Parameters)this.params);
                int written = writeBuf.position() - oldPos;
                this.bytesWritten += (long)written;
                this.inBuf.clear();
                this.finished = true;
                if (!direct) {
                    this.outBuf.flip();
                    int n = Math.min(written, len);
                    this.outBuf.get(b, off, n);
                    return n;
                }
                return written;
            }
            this.finished = true;
        }
        return 0;
    }

    public void end() {
    }

    public void finish() {
        this.finish = true;
    }

    public boolean finished() {
        return this.finished && !this.outBuf.hasRemaining();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public boolean needsInput() {
        return !this.finished();
    }

    public void reinit(Configuration conf) {
        if (conf != null) {
            this.params.setQuality(BrotliCodec.getLevel(conf));
            this.params.setWindow(BrotliCodec.getWindow(conf));
            int newBufferSize = BrotliCodec.getBufferSize(conf);
            if (this.bufferSize != newBufferSize) {
                this.bufferSize = newBufferSize;
                this.inBuf = ByteBuffer.allocate(this.bufferSize);
                this.outBuf = ByteBuffer.allocate(this.bufferSize);
            }
        }
        this.reset();
    }

    public void reset() {
        this.inBuf.clear();
        this.outBuf.clear();
        this.outBuf.position(this.outBuf.capacity());
        this.bytesRead = 0L;
        this.bytesWritten = 0L;
        this.finish = false;
        this.finished = false;
    }

    public void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException("setDictionary is not supported");
    }

    public void setInput(byte[] b, int off, int len) {
        if (this.inBuf.remaining() < len) {
            int needed = CompressionUtil.roundInt2((int)(this.inBuf.capacity() + len));
            ByteBuffer newBuf = ByteBuffer.allocate(needed);
            this.inBuf.flip();
            newBuf.put(this.inBuf);
            this.inBuf = newBuf;
        }
        this.inBuf.put(b, off, len);
        this.bytesRead += (long)len;
        this.finished = false;
    }

    int maxCompressedLength(int len) {
        return len + CompressionUtil.compressionOverhead((int)len);
    }

    static {
        Brotli4jLoader.ensureAvailability();
    }
}

