/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallEvent;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelDuplexHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPromise;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class BufferCallBeforeInitHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BufferCallBeforeInitHandler.class);
    static final String NAME = "BufferCall";
    private static final BufferCallEvent SUCCESS_EVENT = new BufferCallEvent(BufferCallAction.FLUSH, null);
    private final Map<Integer, Call> id2Call = new HashMap<Integer, Call>();

    BufferCallBeforeInitHandler() {
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof Call) {
            Call call = (Call)msg;
            this.id2Call.put(call.id, call);
            promise.trySuccess();
        } else {
            NettyFutureUtils.consume(ctx.write(msg, promise));
        }
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof BufferCallEvent) {
            BufferCallEvent bcEvt = (BufferCallEvent)evt;
            switch (bcEvt.action) {
                case FLUSH: {
                    for (Call call : this.id2Call.values()) {
                        NettyFutureUtils.safeWrite(ctx, call);
                    }
                    ctx.flush();
                    ctx.pipeline().remove(this);
                    break;
                }
                case FAIL: {
                    for (Call call : this.id2Call.values()) {
                        call.setException(bcEvt.error);
                    }
                    break;
                }
            }
        } else if (evt instanceof CallEvent) {
            this.id2Call.remove(((CallEvent)evt).call.id);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    private boolean isSslError(Throwable cause) {
        Throwable error = cause;
        do {
            if (!(error instanceof SSLException)) continue;
            return true;
        } while ((error = error.getCause()) != null);
        return false;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.isSslError(cause)) {
            LOG.debug("got ssl exception, which should have already been proceeded, log it here to prevent it being passed to netty's TailContext and trigger a confusing WARN message", cause);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public static final class BufferCallEvent {
        public final BufferCallAction action;
        public final IOException error;

        private BufferCallEvent(BufferCallAction action, IOException error) {
            this.action = action;
            this.error = error;
        }

        public static BufferCallEvent success() {
            return SUCCESS_EVENT;
        }

        public static BufferCallEvent fail(IOException error) {
            return new BufferCallEvent(BufferCallAction.FAIL, error);
        }
    }

    private static enum BufferCallAction {
        FLUSH,
        FAIL;

    }
}

