/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.regionserver.DateTieredMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomTieringMultiFileWriter
extends DateTieredMultiFileWriter {
    public static final byte[] CUSTOM_TIERING_TIME_RANGE = Bytes.toBytes((String)"CUSTOM_TIERING_TIME_RANGE");
    private NavigableMap<Long, TimeRangeTracker> lowerBoundary2TimeRanger = new TreeMap<Long, TimeRangeTracker>();

    public CustomTieringMultiFileWriter(List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies, boolean needEmptyFile, Function<Cell, Long> tieringFunction) {
        super(lowerBoundaries, lowerBoundariesPolicies, needEmptyFile, tieringFunction);
        for (Long lowerBoundary : lowerBoundaries) {
            this.lowerBoundary2TimeRanger.put(lowerBoundary, null);
        }
    }

    @Override
    public void append(Cell cell) throws IOException {
        super.append(cell);
        long tieringValue = (Long)this.tieringFunction.apply(cell);
        Map.Entry<Long, TimeRangeTracker> entry = this.lowerBoundary2TimeRanger.floorEntry(tieringValue);
        if (entry.getValue() == null) {
            TimeRangeTracker timeRangeTracker = TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC);
            timeRangeTracker.setMin(tieringValue);
            timeRangeTracker.setMax(tieringValue);
            this.lowerBoundary2TimeRanger.put(entry.getKey(), timeRangeTracker);
            ((HFileWriterImpl)((StoreFileWriter)this.lowerBoundary2Writer.get(entry.getKey())).getLiveFileWriter()).setTimeRangeTrackerForTiering(() -> timeRangeTracker);
        } else {
            TimeRangeTracker timeRangeTracker = entry.getValue();
            if (timeRangeTracker.getMin() > tieringValue) {
                timeRangeTracker.setMin(tieringValue);
            }
            if (timeRangeTracker.getMax() < tieringValue) {
                timeRangeTracker.setMax(tieringValue);
            }
        }
    }

    @Override
    public List<Path> commitWriters(long maxSeqId, boolean majorCompaction, Collection<HStoreFile> storeFiles) throws IOException {
        for (Map.Entry entry : this.lowerBoundary2Writer.entrySet()) {
            StoreFileWriter writer = (StoreFileWriter)entry.getValue();
            if (writer == null) continue;
            writer.appendFileInfo(CUSTOM_TIERING_TIME_RANGE, TimeRangeTracker.toByteArray((TimeRangeTracker)this.lowerBoundary2TimeRanger.get(entry.getKey())));
        }
        return super.commitWriters(maxSeqId, majorCompaction, storeFiles);
    }
}

