/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.ir.JIT;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.ir.targets.SelfInvokeSite;
import org.jruby.ir.targets.SiteTracker;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.JRubyCallSite;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public abstract class InvokeSite
extends MutableCallSite {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeSite.class);
    private static final boolean LOG_BINDING;
    final Signature signature;
    final Signature fullSignature;
    final int arity;
    protected final String methodName;
    final MethodHandle fallback;
    private final SiteTracker tracker = new SiteTracker();
    private final long siteID = JRubyCallSite.SITE_ID.getAndIncrement();
    private final int argOffset;
    protected final String file;
    protected final int line;
    private boolean boundOnce;
    private boolean literalClosure;
    CacheEntry cache = CacheEntry.NULL_CACHE;
    public final CallType callType;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle ESCAPE_BLOCK;
    private static final Map<Signature, MethodHandle> BLOCK_ESCAPES;
    public static final MethodHandle NEGATE;
    private static final MethodHandle TEST_CLASS;

    public String name() {
        return this.methodName;
    }

    public InvokeSite(MethodType type2, String name2, CallType callType, String file2, int line) {
        this(type2, name2, callType, false, file2, line);
    }

    public InvokeSite(MethodType type2, String name2, CallType callType, boolean literalClosure, String file2, int line) {
        super(type2);
        int arity2;
        Signature startSig;
        this.methodName = name2;
        this.callType = callType;
        this.literalClosure = literalClosure;
        this.file = file2;
        this.line = line;
        if (callType == CallType.SUPER) {
            startSig = JRubyCallSite.STANDARD_SUPER_SIG;
            this.argOffset = 4;
        } else {
            startSig = JRubyCallSite.STANDARD_SITE_SIG;
            this.argOffset = 3;
        }
        if (type2.parameterType(type2.parameterCount() - 1) == Block.class) {
            arity2 = type2.parameterCount() - (this.argOffset + 1);
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i2 = 0; i2 < arity2; ++i2) {
                    startSig = startSig.appendArg("arg" + i2, IRubyObject.class);
                }
            }
            this.fullSignature = this.signature = (startSig = startSig.appendArg("block", Block.class));
        } else {
            arity2 = type2.parameterCount() - this.argOffset;
            if (arity2 == 1 && type2.parameterType(this.argOffset) == IRubyObject[].class) {
                arity2 = -1;
                startSig = startSig.appendArg("args", IRubyObject[].class);
            } else {
                for (int i3 = 0; i3 < arity2; ++i3) {
                    startSig = startSig.appendArg("arg" + i3, IRubyObject.class);
                }
            }
            this.signature = startSig;
            this.fullSignature = startSig.appendArg("block", Block.class);
        }
        this.arity = arity2;
        this.fallback = this.prepareBinder(true).invokeVirtualQuiet(Bootstrap.LOOKUP, "invoke");
    }

    public static CallSite bootstrap(InvokeSite site, MethodHandles.Lookup lookup) {
        site.setInitialTarget(site.fallback);
        return site;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject invoke(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        SwitchPoint switchPoint = (SwitchPoint)selfClass.getInvalidator().getData();
        CacheEntry entry = selfClass.searchWithCache(this.methodName);
        DynamicMethod method2 = entry.method;
        MethodHandle mh = null;
        boolean methodMissing = false;
        if (this.methodMissing(entry, caller2)) {
            methodMissing = true;
            if (this.testThresholds(selfClass) == CacheAction.FAIL) {
                this.logFail();
                this.bindToFail();
            } else {
                this.logMethodMissing();
            }
            method2 = Helpers.selectMethodMissing(context, selfClass, entry.method.getVisibility(), this.methodName, this.callType);
            if (method2 instanceof Helpers.MethodMissingMethod) {
                entry = ((Helpers.MethodMissingMethod)method2).entry;
                method2 = entry.method;
            } else {
                entry = new CacheEntry(method2, selfClass, entry.token);
            }
            try {
                mh = Bootstrap.buildMethodMissingHandle(this, entry, self2);
            }
            catch (Throwable t) {
                t.printStackTrace();
                Helpers.throwException(t);
            }
        } else {
            mh = this.getHandle(self2, entry);
        }
        if (this.literalClosure) {
            mh = Binder.from(mh.type()).tryFinally(InvokeSite.getBlockEscape(this.signature)).invoke(mh);
        }
        this.updateInvocationTarget(mh, self2, selfClass, entry.method, switchPoint);
        if (this.literalClosure) {
            try {
                if (methodMissing) {
                    IRubyObject iRubyObject = method2.call(context, self2, entry.sourceModule, this.methodName, Helpers.arrayOf(context.runtime.newSymbol(this.methodName), args2), block);
                    return iRubyObject;
                }
                IRubyObject iRubyObject = method2.call(context, self2, entry.sourceModule, this.methodName, args2, block);
                return iRubyObject;
            }
            finally {
                block.escape();
            }
        }
        if (methodMissing) {
            return method2.call(context, self2, entry.sourceModule, this.methodName, Helpers.arrayOf(context.runtime.newSymbol(this.methodName), args2), block);
        }
        return method2.call(context, self2, entry.sourceModule, this.methodName, args2, block);
    }

    private static MethodHandle getBlockEscape(Signature signature) {
        Signature voidSignature = signature.changeReturn(Void.TYPE);
        MethodHandle escape2 = BLOCK_ESCAPES.get(voidSignature);
        if (escape2 == null) {
            escape2 = SmartBinder.from(voidSignature).permute("block").invoke(ESCAPE_BLOCK).handle();
            BLOCK_ESCAPES.put(voidSignature, escape2);
        }
        return escape2;
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject[] args2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, args2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, Block block) throws Throwable {
        return this.fail(context, caller2, self2, IRubyObject.NULL_ARRAY, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public IRubyObject fail(ThreadContext context, IRubyObject caller2, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws Throwable {
        RubyClass selfClass = InvokeSite.pollAndGetClass(context, self2);
        String name2 = this.methodName;
        CacheEntry entry = this.cache;
        if (entry.typeOk(selfClass)) {
            return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
        }
        entry = selfClass.searchWithCache(name2);
        if (this.methodMissing(entry, caller2)) {
            return InvokeSite.callMethodMissing(entry, this.callType, context, self2, selfClass, name2, arg0, arg1, arg2, block);
        }
        this.cache = entry;
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    public Binder prepareBinder(boolean varargs) {
        SmartBinder binder = SmartBinder.from(this.signature);
        if ((varargs || this.arity > 3) && this.arity != -1) {
            binder = this.arity == 0 ? binder.insert(this.argOffset, "args", IRubyObject.NULL_ARRAY) : binder.collect("args", "arg[0-9]+");
        }
        if (this.signature.lastArgType() != Block.class) {
            binder = binder.append("block", Block.NULL_BLOCK);
        }
        binder = binder.insert(0, "site", this);
        return binder.binder();
    }

    MethodHandle getHandle(IRubyObject self2, CacheEntry entry) throws Throwable {
        boolean blockGiven = this.signature.lastArgType() == Block.class;
        MethodHandle mh = this.buildNewInstanceHandle(entry, self2);
        if (mh == null) {
            mh = this.buildNotEqualHandle(entry, self2);
        }
        if (mh == null) {
            mh = Bootstrap.buildNativeHandle(this, entry, blockGiven);
        }
        if (mh == null) {
            mh = this.buildJavaFieldHandle(this, entry, self2);
        }
        if (mh == null) {
            mh = Bootstrap.buildIndyHandle(this, entry);
        }
        if (mh == null) {
            mh = Bootstrap.buildJittedHandle(this, entry, blockGiven);
        }
        if (mh == null) {
            mh = Bootstrap.buildAttrHandle(this, entry, self2);
        }
        if (mh == null) {
            mh = this.buildAliasHandle(entry, self2);
        }
        if (mh == null) {
            mh = this.buildStructHandle(entry);
        }
        if (mh == null) {
            mh = Bootstrap.buildGenericHandle(this, entry);
        }
        assert (mh != null) : "we should have a method handle of some sort by now";
        return mh;
    }

    MethodHandle buildJavaFieldHandle(InvokeSite site, CacheEntry entry, IRubyObject self2) throws Throwable {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof InstanceFieldGetter) {
            if (site.arity != 0 || site.signature.lastArgType() == Block.class) {
                return null;
            }
            Field field2 = ((InstanceFieldGetter)method2).getField();
            if (!IRubyObject.class.isAssignableFrom(field2.getType())) {
                return null;
            }
            MethodHandle fieldHandle = (MethodHandle)method2.getHandle();
            if (fieldHandle != null) {
                return fieldHandle;
            }
            fieldHandle = LOOKUP.unreflectGetter(field2);
            MethodHandle filter = self2.getRuntime().getNullToNilHandle();
            MethodHandle receiverConverter = Binder.from(field2.getDeclaringClass(), IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy");
            fieldHandle = Binder.from(site.type()).permute(2).filter(0, receiverConverter).filterReturn(filter).cast(fieldHandle.type()).invoke(fieldHandle);
            method2.setHandle(fieldHandle);
            return fieldHandle;
        }
        if (method2 instanceof InstanceFieldSetter) {
            if (site.arity != 1 || site.signature.lastArgType() == Block.class) {
                return null;
            }
            Field field3 = ((InstanceFieldSetter)method2).getField();
            if (!IRubyObject.class.isAssignableFrom(field3.getType())) {
                return null;
            }
            MethodHandle fieldHandle = (MethodHandle)method2.getHandle();
            if (fieldHandle != null) {
                return fieldHandle;
            }
            fieldHandle = LOOKUP.unreflectSetter(field3);
            MethodHandle receiverConverter = Binder.from(field3.getDeclaringClass(), IRubyObject.class, new Class[0]).cast(Object.class, IRubyObject.class).invokeStaticQuiet(MethodHandles.lookup(), JavaUtil.class, "objectFromJavaProxy");
            fieldHandle = Binder.from(site.type()).permute(2, 3).filter(0, receiverConverter).filterReturn(MethodHandles.constant(IRubyObject.class, self2.getRuntime().getNil())).cast(fieldHandle.type()).invoke(fieldHandle);
            method2.setHandle(fieldHandle);
            return fieldHandle;
        }
        return null;
    }

    MethodHandle buildNewInstanceHandle(CacheEntry entry, IRubyObject self2) {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 == self2.getRuntime().getBaseNewMethod()) {
            RubyClass recvClass = (RubyClass)self2;
            CallSite initSite = SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:initialize", this.type(), this.literalClosure ? 1 : 0, this.file, this.line);
            MethodHandle initHandle = initSite.dynamicInvoker();
            MethodHandle allocFilter = Binder.from(IRubyObject.class, IRubyObject.class, new Class[0]).cast(IRubyObject.class, RubyClass.class).insert(0, new Class[]{ObjectAllocator.class, Ruby.class}, new Object[]{recvClass.getAllocator(), self2.getRuntime()}).invokeVirtualQuiet(LOOKUP, "allocate");
            mh = SmartBinder.from(LOOKUP, this.signature).filter("self", allocFilter).fold("dummy", initHandle).permute("self").identity().handle();
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tbound as new instance creation " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle buildNotEqualHandle(CacheEntry entry, IRubyObject self2) {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        Ruby runtime2 = self2.getRuntime();
        if (method2.isBuiltin()) {
            CallSite equalSite = null;
            if (method2.getImplementationClass() == runtime2.getBasicObject() && this.name().equals("!=")) {
                equalSite = SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:==", this.type(), this.literalClosure ? 1 : 0, this.file, this.line);
            } else if (method2.getImplementationClass() == runtime2.getKernel() && this.name().equals("!~")) {
                equalSite = SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:=~", this.type(), this.literalClosure ? 1 : 0, this.file, this.line);
            }
            if (equalSite != null) {
                MethodHandle equalHandle = equalSite.dynamicInvoker();
                MethodHandle filter = MethodHandles.insertArguments(NEGATE, 1, runtime2.getNil(), runtime2.getTrue(), runtime2.getFalse());
                mh = MethodHandles.filterReturnValue(equalHandle, filter);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound as specialized " + this.name() + ":" + Bootstrap.logMethod(method2), new Object[0]);
                }
            }
        }
        return mh;
    }

    public static IRubyObject negate(IRubyObject object, RubyNil nil, RubyBoolean.True tru, RubyBoolean.False fals) {
        return object == nil || object == fals ? tru : fals;
    }

    MethodHandle buildAliasHandle(CacheEntry entry, IRubyObject self2) throws Throwable {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof PartialDelegatingMethod) {
            mh = this.getHandle(self2, new CacheEntry(((PartialDelegatingMethod)method2).getDelegate(), entry.sourceModule, entry.token));
        } else if (method2 instanceof AliasMethod) {
            AliasMethod alias = (AliasMethod)method2;
            DynamicMethod innerMethod = alias.getRealMethod();
            String name2 = alias.getName();
            InvokeSite innerSite = (InvokeSite)SelfInvokeSite.bootstrap(LOOKUP, "callFunctional:" + name2, this.type(), this.literalClosure ? 1 : 0, this.file, this.line);
            mh = innerSite.getHandle(self2, new CacheEntry(innerMethod, entry.sourceModule, entry.token));
            alias.setHandle(mh);
            if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tbound directly through alias to " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle buildStructHandle(CacheEntry entry) throws Throwable {
        MethodHandle mh = null;
        DynamicMethod method2 = entry.method;
        if (method2 instanceof RubyStruct.Accessor) {
            if (this.arity == 0) {
                RubyStruct.Accessor accessor = (RubyStruct.Accessor)method2;
                int index2 = accessor.getIndex();
                mh = Binder.from(this.type()).cast(this.type().changeParameterType(2, RubyStruct.class)).permute(2).append(index2).invokeVirtual(LOOKUP, "get");
                method2.setHandle(mh);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly as Struct accessor " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tcalled struct accessor with arity > 0 " + Bootstrap.logMethod(method2), new Object[0]);
            }
        } else if (method2 instanceof RubyStruct.Mutator) {
            if (this.arity == 1) {
                RubyStruct.Mutator mutator = (RubyStruct.Mutator)method2;
                int index3 = mutator.getIndex();
                mh = Binder.from(this.type()).cast(this.type().changeParameterType(2, RubyStruct.class)).permute(2, 3).append(index3).invokeVirtual(LOOKUP, "set");
                method2.setHandle(mh);
                if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                    LOG.info(this.name() + "\tbound directly as Struct mutator " + Bootstrap.logMethod(method2), new Object[0]);
                }
            } else if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
                LOG.info(this.name() + "\tcalled struct mutator with arity > 1 " + Bootstrap.logMethod(method2), new Object[0]);
            }
        }
        return mh;
    }

    MethodHandle updateInvocationTarget(MethodHandle target, IRubyObject self2, RubyModule testClass, DynamicMethod method2, SwitchPoint switchPoint) {
        MethodHandle fallback;
        CacheAction cacheAction = this.testThresholds(testClass);
        switch (cacheAction) {
            case FAIL: {
                this.logFail();
                return this.bindToFail();
            }
            case PIC: {
                this.logPic(method2);
                fallback = this.getTarget();
                break;
            }
            case REBIND: 
            case BIND: {
                this.logBind(cacheAction);
                fallback = this.fallback;
                break;
            }
            default: {
                throw new RuntimeException("invalid cache action: " + (Object)((Object)cacheAction));
            }
        }
        SmartHandle test2 = self2 instanceof RubySymbol || self2 instanceof RubyFixnum || self2 instanceof RubyFloat || self2 instanceof RubyNil || self2 instanceof RubyBoolean.True || self2 instanceof RubyBoolean.False ? SmartBinder.from(this.signature.asFold(Boolean.TYPE)).permute("self").insert(1, "selfJavaType", self2.getClass()).cast(Boolean.TYPE, Object.class, Class.class).invoke(TEST_CLASS) : SmartBinder.from(this.signature.changeReturn(Boolean.TYPE)).permute("self").insert(0, "selfClass", RubyClass.class, (Object)testClass).invokeStaticQuiet(Bootstrap.LOOKUP, Bootstrap.class, "testType");
        MethodHandle gwt = MethodHandles.guardWithTest(test2.handle(), target, fallback);
        gwt = switchPoint.guardWithTest(gwt, fallback);
        this.setTarget(gwt);
        this.tracker.addType(testClass.id);
        return target;
    }

    private void logMethodMissing() {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\ttriggered site #" + this.siteID + " method_missing (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logBind(CacheAction action) {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\ttriggered site #" + this.siteID + ' ' + (Object)((Object)action) + " (" + this.file + ":" + this.line + ")", new Object[0]);
        }
    }

    private void logPic(DynamicMethod method2) {
        if (LOG_BINDING) {
            LOG.debug(this.methodName + "\tsite #" + this.siteID + " added to PIC " + InvokeSite.logMethod(method2), new Object[0]);
        }
    }

    private void logFail() {
        if (LOG_BINDING) {
            if (this.tracker.clearCount() > Options.INVOKEDYNAMIC_MAXFAIL.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " failed more than " + Options.INVOKEDYNAMIC_MAXFAIL.load() + " times; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            } else if (this.tracker.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
                LOG.info(this.methodName + "\tat site #" + this.siteID + " encountered more than " + Options.INVOKEDYNAMIC_MAXPOLY.load() + " types; bailing out (" + this.file + ":" + this.line + ")", new Object[0]);
            }
        }
    }

    private MethodHandle bindToFail() {
        MethodHandle target = this.prepareBinder(false).invokeVirtualQuiet(LOOKUP, "fail");
        this.setTarget(target);
        return target;
    }

    CacheAction testThresholds(RubyModule testClass) {
        if (this.tracker.clearCount() > Options.INVOKEDYNAMIC_MAXFAIL.load() || !this.tracker.hasSeenType(testClass.id) && this.tracker.seenTypesCount() + 1 > Options.INVOKEDYNAMIC_MAXPOLY.load()) {
            return CacheAction.FAIL;
        }
        if (this.tracker.seenTypesCount() > 0 && this.getTarget() != null && !this.tracker.hasSeenType(testClass.id)) {
            return CacheAction.PIC;
        }
        this.tracker.clearTypes();
        return this.boundOnce ? CacheAction.REBIND : CacheAction.BIND;
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self2) {
        context.callThreadPoll();
        return RubyBasicObject.getMetaClass(self2);
    }

    @Override
    public void setTarget(MethodHandle target) {
        super.setTarget(target);
        this.boundOnce = true;
    }

    public void setInitialTarget(MethodHandle target) {
        super.setTarget(target);
    }

    public abstract boolean methodMissing(CacheEntry var1, IRubyObject var2);

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject[] args2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, args2, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self2, RubyClass selfClass, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.callMethodMissing(context, self2, selfClass, entry.method.getVisibility(), name2, callType, arg0, arg1, arg2, block);
    }

    private static String logMethod(DynamicMethod method2) {
        return "[#" + method2.getSerialNumber() + ' ' + method2.getImplementationClass() + ']';
    }

    @JIT
    public static boolean testClass(Object object, Class clazz) {
        return object.getClass() == clazz;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name() + ",arity=" + this.arity + ",type=" + this.type() + ",file=" + this.file + ",line=" + this.line + ']';
    }

    static {
        if (Options.INVOKEDYNAMIC_LOG_BINDING.load().booleanValue()) {
            LOG.setDebugEnable(true);
        }
        LOG_BINDING = LOG.isDebugEnabled();
        LOOKUP = MethodHandles.lookup();
        ESCAPE_BLOCK = Binder.from(Void.TYPE, Block.class, new Class[0]).invokeVirtualQuiet(LOOKUP, "escape");
        BLOCK_ESCAPES = Collections.synchronizedMap(new HashMap());
        NEGATE = Binder.from(IRubyObject.class, IRubyObject.class, RubyNil.class, RubyBoolean.True.class, RubyBoolean.False.class).invokeStaticQuiet(LOOKUP, InvokeSite.class, "negate");
        TEST_CLASS = Binder.from(Boolean.TYPE, Object.class, Class.class).invokeStaticQuiet(LOOKUP, InvokeSite.class, "testClass");
    }

    static enum CacheAction {
        FAIL,
        BIND,
        REBIND,
        PIC;

    }
}

