/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, MediumTests.class})
public class TestIgnoreUnknownFamily {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIgnoreUnknownFamily.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] UNKNOWN_FAMILY = Bytes.toBytes((String)"wrong_cf");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDownAfterTest() throws IOException {
        Admin admin = UTIL.getAdmin();
        for (TableName tableName : admin.listTableNames()) {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
    }

    private void addStoreFileToKnownFamily(RegionInfo region) throws IOException {
        MasterFileSystem mfs = UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        Path regionDir = FSUtils.getRegionDirFromRootDir((Path)CommonFSUtils.getRootDir((Configuration)mfs.getConfiguration()), (RegionInfo)region);
        Path familyDir = new Path(regionDir, Bytes.toString((byte[])UNKNOWN_FAMILY));
        StoreFileWriter writer = new StoreFileWriter.Builder(mfs.getConfiguration(), mfs.getFileSystem()).withOutputDir(familyDir).withFileContext(new HFileContextBuilder().build()).build();
        writer.close();
    }

    @Test
    public void testSplit() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = UTIL.getAdmin();
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        RegionInfo region = (RegionInfo)admin.getRegions(tableName).get(0);
        this.addStoreFileToKnownFamily(region);
        admin.splitRegionAsync(region.getRegionName(), Bytes.toBytes((int)0)).get(30L, TimeUnit.SECONDS);
    }

    @Test
    public void testMerge() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Admin admin = UTIL.getAdmin();
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build(), (byte[][])new byte[][]{Bytes.toBytes((int)0)});
        List regions = admin.getRegions(tableName);
        this.addStoreFileToKnownFamily((RegionInfo)regions.get(0));
        admin.mergeRegionsAsync(((RegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(1)).getEncodedNameAsBytes(), false).get(30L, TimeUnit.SECONDS);
    }
}

