/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic.codec;

import io.lettuce.core.KeyValue;
import io.lettuce.core.Range;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.Value;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.annotation.Key;
import io.lettuce.core.dynamic.codec.RedisCodecResolver;
import io.lettuce.core.dynamic.parameter.Parameter;
import io.lettuce.core.dynamic.support.ClassTypeInformation;
import io.lettuce.core.dynamic.support.TypeInformation;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationRedisCodecResolver
implements RedisCodecResolver {
    private final List<RedisCodec<?, ?>> codecs;

    public AnnotationRedisCodecResolver(List<RedisCodec<?, ?>> codecs) {
        LettuceAssert.notNull(codecs, "List of RedisCodecs must not be null");
        this.codecs = LettuceLists.unmodifiableList(codecs);
    }

    @Override
    public RedisCodec<?, ?> resolve(CommandMethod commandMethod) {
        RedisCodec<?, ?> resolvedCodec;
        LettuceAssert.notNull((Object)commandMethod, "CommandMethod must not be null");
        Set<Class<?>> keyTypes = this.findTypes(commandMethod, Key.class);
        Set<Class<?>> valueTypes = this.findTypes(commandMethod, io.lettuce.core.dynamic.annotation.Value.class);
        if (keyTypes.isEmpty() && valueTypes.isEmpty()) {
            Voted<RedisCodec<?, ?>> voted = this.voteForTypeMajority(commandMethod);
            if (voted != null) {
                return (RedisCodec)((Voted)voted).subject;
            }
            return this.codecs.get(0);
        }
        if ((keyTypes.size() == 1 && this.hasAtMostOne(valueTypes) || valueTypes.size() == 1 && this.hasAtMostOne(keyTypes)) && (resolvedCodec = this.resolveCodec(keyTypes, valueTypes)) != null) {
            return resolvedCodec;
        }
        throw new IllegalStateException(String.format("Cannot resolve Codec for method %s", commandMethod.getMethod()));
    }

    private boolean hasAtMostOne(Collection<?> collection) {
        return collection.size() <= 1;
    }

    private Voted<RedisCodec<?, ?>> voteForTypeMajority(CommandMethod commandMethod) {
        List votes = this.codecs.stream().map(redisCodec -> new Voted<RedisCodec>((RedisCodec)redisCodec, 0)).collect(Collectors.toList());
        commandMethod.getParameters().getBindableParameters().forEach(parameter -> AnnotationRedisCodecResolver.vote(votes, parameter));
        Collections.sort(votes);
        if (votes.isEmpty()) {
            return null;
        }
        Voted voted = (Voted)votes.get(votes.size() - 1);
        if (voted.votes == 0) {
            return null;
        }
        return voted;
    }

    private static void vote(List<Voted<RedisCodec<?, ?>>> votes, Parameter parameter) {
        for (Voted<RedisCodec<?, ?>> vote : votes) {
            ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(((RedisCodec)((Voted)vote).subject).getClass());
            TypeInformation superTypeInformation = typeInformation.getSuperTypeInformation((Class)RedisCodec.class);
            List<TypeInformation<?>> typeArguments = superTypeInformation.getTypeArguments();
            if (typeArguments.size() != 2) continue;
            TypeInformation<?> parameterType = parameter.getTypeInformation();
            TypeInformation<?> parameterKeyType = ParameterWrappers.getKeyType(parameterType);
            TypeInformation<?> parameterValueType = ParameterWrappers.getValueType(parameterType);
            TypeInformation<?> keyType = typeArguments.get(0);
            TypeInformation<?> valueType = typeArguments.get(1);
            if (keyType.isAssignableFrom(parameterKeyType)) {
                ((Voted)vote).votes++;
            }
            if (!valueType.isAssignableFrom(parameterValueType)) continue;
            ((Voted)vote).votes++;
        }
    }

    private RedisCodec<?, ?> resolveCodec(Set<Class<?>> keyTypes, Set<Class<?>> valueTypes) {
        Class<?> keyType = keyTypes.isEmpty() ? null : keyTypes.iterator().next();
        Class<?> valueType = valueTypes.isEmpty() ? null : valueTypes.iterator().next();
        for (RedisCodec<?, ?> codec : this.codecs) {
            ClassTypeInformation<?> typeInformation = ClassTypeInformation.from(codec.getClass());
            TypeInformation keyTypeArgument = typeInformation.getTypeArgument((Class)RedisCodec.class, 0);
            TypeInformation valueTypeArgument = typeInformation.getTypeArgument((Class)RedisCodec.class, 1);
            if (keyTypeArgument == null || valueTypeArgument == null) continue;
            boolean keyMatch = false;
            boolean valueMatch = false;
            if (keyType != null) {
                keyMatch = keyTypeArgument.isAssignableFrom(ClassTypeInformation.from(keyType));
            }
            if (valueType != null) {
                valueMatch = valueTypeArgument.isAssignableFrom(ClassTypeInformation.from(valueType));
            }
            if (keyType != null && valueType != null && keyMatch && valueMatch) {
                return codec;
            }
            if (keyType != null && valueType == null && keyMatch) {
                return codec;
            }
            if (keyType != null || valueType == null || !valueMatch) continue;
            return codec;
        }
        return null;
    }

    Set<Class<?>> findTypes(CommandMethod commandMethod, Class<?> annotation) {
        LinkedHashSet types = new LinkedHashSet();
        for (Parameter parameter : commandMethod.getParameters().getBindableParameters()) {
            types.addAll(parameter.getAnnotations().stream().filter(parameterAnnotation -> annotation.isAssignableFrom(parameterAnnotation.getClass())).map(parameterAnnotation -> {
                TypeInformation<?> typeInformation = parameter.getTypeInformation();
                if (annotation == Key.class && ParameterWrappers.hasKeyType(typeInformation)) {
                    TypeInformation<?> parameterKeyType = ParameterWrappers.getKeyType(typeInformation);
                    return parameterKeyType.getType();
                }
                return ParameterWrappers.getValueType(typeInformation).getType();
            }).collect(Collectors.toList()));
        }
        return types;
    }

    protected static class ParameterWrappers {
        private static final Set<Class<?>> WRAPPERS = new HashSet();
        private static final Set<Class<?>> WITH_KEY_TYPE = new HashSet();
        private static final Set<Class<?>> WITH_VALUE_TYPE = new HashSet();

        protected ParameterWrappers() {
        }

        public static boolean supports(TypeInformation<?> typeInformation) {
            return WRAPPERS.contains(typeInformation.getType()) || typeInformation.getType().isArray() && !typeInformation.getType().equals(byte[].class);
        }

        public static boolean hasKeyType(TypeInformation<?> typeInformation) {
            return WITH_KEY_TYPE.contains(typeInformation.getType());
        }

        public static boolean hasValueType(TypeInformation<?> typeInformation) {
            return WITH_VALUE_TYPE.contains(typeInformation.getType());
        }

        public static TypeInformation<?> getKeyType(TypeInformation<?> typeInformation) {
            if (!ParameterWrappers.supports(typeInformation) || !ParameterWrappers.hasKeyType(typeInformation)) {
                return typeInformation;
            }
            return typeInformation.getComponentType();
        }

        public static TypeInformation<?> getValueType(TypeInformation<?> typeInformation) {
            if (!ParameterWrappers.supports(typeInformation) || typeInformation.getComponentType() == null) {
                return typeInformation;
            }
            if (!ParameterWrappers.hasValueType(typeInformation)) {
                return typeInformation.getComponentType();
            }
            List<TypeInformation<?>> typeArguments = typeInformation.getTypeArguments();
            if (ParameterWrappers.hasKeyType(typeInformation)) {
                return typeArguments.get(1);
            }
            return typeArguments.get(0);
        }

        static {
            WRAPPERS.add(Value.class);
            WRAPPERS.add(KeyValue.class);
            WRAPPERS.add(ScoredValue.class);
            WRAPPERS.add(Range.class);
            WRAPPERS.add(List.class);
            WRAPPERS.add(Collection.class);
            WRAPPERS.add(Set.class);
            WRAPPERS.add(Iterable.class);
            WRAPPERS.add(Map.class);
            WITH_VALUE_TYPE.add(Value.class);
            WITH_VALUE_TYPE.add(KeyValue.class);
            WITH_KEY_TYPE.add(KeyValue.class);
            WITH_VALUE_TYPE.add(ScoredValue.class);
            WITH_KEY_TYPE.add(Map.class);
            WITH_VALUE_TYPE.add(Map.class);
        }
    }

    private static class Voted<T>
    implements Comparable<Voted<?>> {
        private T subject;
        private int votes;

        Voted(T subject, int votes) {
            this.subject = subject;
            this.votes = votes;
        }

        @Override
        public int compareTo(Voted<?> o) {
            return this.votes - o.votes;
        }
    }
}

