/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.util;

public class Parser {
    public static String replaceProcessing(String sql) {
        boolean flag = false;
        if (!sql.endsWith(";")) {
            sql = sql + ";";
            flag = true;
        }
        char[] aChars = sql.toCharArray();
        StringBuilder nativeSql = new StringBuilder(sql.length() + 10);
        int fragmentStart = 0;
        for (int i = 0; i < aChars.length; ++i) {
            char aChar = aChars[i];
            if (aChar == '?') {
                nativeSql.append(aChars, fragmentStart, i - fragmentStart).append(" ? ");
                fragmentStart = i + 1;
                continue;
            }
            if (aChar == '\'') {
                char qChar = ' ';
                if (i != 0) {
                    qChar = aChars[i - 1];
                }
                if (aChars[i = "q".equalsIgnoreCase(String.valueOf(qChar)) ? Parser.parseQEscape(aChars, i) : Parser.parseSingleQuotes(aChars, i)] != ';') continue;
                nativeSql.append(aChars, fragmentStart, i - fragmentStart + 1);
                fragmentStart = i + 1;
                continue;
            }
            if (aChar == ';') {
                nativeSql.append(aChars, fragmentStart, i - fragmentStart + 1);
                fragmentStart = i + 1;
                continue;
            }
            if (aChar != '\"' || aChars[i = Parser.parseDoubleQuotes(aChars, i)] != ';') continue;
            nativeSql.append(aChars, fragmentStart, i - fragmentStart + 1);
            fragmentStart = i + 1;
        }
        if (flag) {
            nativeSql.deleteCharAt(nativeSql.length() - 1);
        }
        return String.valueOf(nativeSql);
    }

    public static int parseSingleQuotes(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != '\'') continue;
            if (qChars[offset + 1] == '\'') {
                ++offset;
                continue;
            }
            return offset;
        }
        return offset - 1;
    }

    public static int parseQEscape(char[] qChars, int offset) {
        char qChar;
        if ((qChar = qChars[++offset]) == ';' && offset == qChars.length - 1) {
            return offset;
        }
        offset = qChar == '(' ? Parser.parseParenthesis(qChars, offset) : (qChar == '[' ? Parser.parseSquareBrackets(qChars, offset) : (qChar == '{' ? Parser.parseBrace(qChars, offset) : (qChar == '<' ? Parser.parseAngleBrackets(qChars, offset) : (qChar == '\'' ? Parser.parseQSingleQuotes(qChars, offset) : Parser.parseOtherEscape(qChars, qChar, offset)))));
        if (qChars[offset + 1] == '\'') {
            ++offset;
        }
        return offset;
    }

    public static int parseParenthesis(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != ')' || qChars[offset + 1] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseSquareBrackets(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != ']' || qChars[offset + 1] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseBrace(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != '}' || qChars[offset + 1] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseAngleBrackets(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != '>' || qChars[offset + 1] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseQSingleQuotes(char[] qChars, int offset) {
        while (++offset < qChars.length) {
            if (offset + 2 >= qChars.length || qChars[offset] != '\'' || qChars[offset + 1] != '\'' || qChars[offset + 2] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseOtherEscape(char[] qChars, char other, int offset) {
        while (++offset < qChars.length) {
            if (qChars[offset] != other || qChars[offset + 1] != '\'') continue;
            return ++offset;
        }
        return offset - 1;
    }

    public static int parseDoubleQuotes(char[] qChars, int offset) {
        while (offset + 1 < qChars.length) {
            if (qChars[++offset] != '\"') continue;
            if (qChars[offset + 1] != '\"') break;
            ++offset;
        }
        return offset;
    }

    public static boolean isArrayWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f' || c == '\u000b';
    }
}

