/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.grant;

import java.util.List;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.grant.GrantDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;

public class GrantOperation
extends DDLOperation<GrantDesc> {
    public GrantOperation(DDLOperationContext context, GrantDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        List<HivePrincipal> hivePrincipals = AuthorizationUtils.getHivePrincipals(((GrantDesc)this.desc).getPrincipals(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        List<HivePrivilege> hivePrivileges = AuthorizationUtils.getHivePrivileges(((GrantDesc)this.desc).getPrivileges(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        HivePrivilegeObject hivePrivilegeObject = PrivilegeUtils.getAuthorizationTranslator(authorizer).getHivePrivilegeObject(((GrantDesc)this.desc).getPrivilegeSubject());
        HivePrincipal grantorPrincipal = new HivePrincipal(((GrantDesc)this.desc).getGrantor(), AuthorizationUtils.getHivePrincipalType(((GrantDesc)this.desc).getGrantorType()));
        authorizer.grantPrivileges(hivePrincipals, hivePrivileges, hivePrivilegeObject, grantorPrincipal, ((GrantDesc)this.desc).isGrantOption());
        return 0;
    }
}

