/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor.service;

import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorFactory;
import org.apache.hadoop.hive.ql.txn.compactor.service.AcidCompactionService;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionService;

public class CompactionExecutorFactory {
    private static final String ICEBERG_COMPACTION_SERVICE_CLASS = "org.apache.iceberg.mr.hive.compaction.IcebergCompactionService";

    public static CompactionService createExecutor(HiveConf conf, IMetaStoreClient msc, CompactorFactory compactorFactory, Table table, boolean collectGenericStats, boolean collectMrStats) throws HiveException {
        CompactionService compactionService;
        if (MetaStoreUtils.isIcebergTable((Map)table.getParameters())) {
            try {
                Class<?> icebergCompactionService = Class.forName(ICEBERG_COMPACTION_SERVICE_CLASS, true, Utilities.getSessionSpecifiedClassLoader());
                compactionService = (CompactionService)icebergCompactionService.newInstance();
                compactionService.init(conf, msc, compactorFactory, false);
            }
            catch (Exception e) {
                throw new HiveException("Failed instantiating and calling Iceberg compaction executor", (Throwable)e);
            }
        } else {
            compactionService = new AcidCompactionService(conf, msc, compactorFactory, collectGenericStats, collectMrStats);
        }
        return compactionService;
    }
}

