/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.RollbackException;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetry;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryCallProperties;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryFunction;
import org.apache.hadoop.hive.metastore.txn.retry.SqlRetryHandler;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class TransactionalRetryProxy<T>
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalRetryProxy.class);
    private final T interfaceObject;
    private final SqlRetryHandler sqlRetryHandler;
    private final MultiDataSourceJdbcResource jdbcResource;

    public static <T> T getProxy(SqlRetryHandler sqlRetryHandler, MultiDataSourceJdbcResource jdbcResourceHandler, T interfaceObject) {
        TransactionalRetryProxy<T> handler = new TransactionalRetryProxy<T>(interfaceObject, sqlRetryHandler, jdbcResourceHandler);
        return (T)Proxy.newProxyInstance(TransactionalRetryProxy.class.getClassLoader(), ClassUtils.getAllInterfaces(interfaceObject.getClass()).toArray(new Class[0]), handler);
    }

    private TransactionalRetryProxy(T interfaceObject, SqlRetryHandler sqlRetryHandler, MultiDataSourceJdbcResource jdbcResource) {
        this.interfaceObject = interfaceObject;
        this.sqlRetryHandler = sqlRetryHandler;
        this.jdbcResource = jdbcResource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String strArgs;
        try {
            strArgs = args == null ? "" : StringUtils.join(Arrays.asList(args), (String)",");
        }
        catch (Exception e) {
            LOG.warn("Error while trying to stringify the method arguments.", (Throwable)e);
            strArgs = "unknown";
        }
        String callerId = method.getName() + "(" + strArgs + ")";
        SqlRetry retry = method.getAnnotation(SqlRetry.class);
        Transactional transactional = method.getAnnotation(Transactional.class);
        ThrowingSupplier functionToCall = () -> {
            try {
                return method.invoke(this.interfaceObject, args);
            }
            catch (InvocationTargetException | UndeclaredThrowableException e) {
                throw e.getCause();
            }
        };
        if (transactional != null) {
            ThrowingSupplier toCall = functionToCall;
            functionToCall = () -> {
                LOG.debug("Invoking method within transactional context: {}", (Object)callerId);
                TransactionContext context = null;
                try {
                    this.jdbcResource.bindDataSource(transactional);
                    context = this.jdbcResource.getTransactionManager().getNewTransaction(transactional.propagation().value());
                    Object result = toCall.execute();
                    LOG.debug("Successfull method invocation within transactional context: {}, going to commit.", (Object)callerId);
                    if (context.isRollbackOnly()) {
                        this.jdbcResource.getTransactionManager().rollback(context);
                    } else if (!context.isCompleted()) {
                        this.jdbcResource.getTransactionManager().commit(context);
                    }
                    Object object = result;
                    return object;
                }
                catch (RollbackException e) {
                    if (context != null && !context.isCompleted()) {
                        this.jdbcResource.getTransactionManager().rollback(context);
                    }
                    Object object = e.getResult();
                    return object;
                }
                catch (Exception e) {
                    if (context != null) {
                        if (transactional.noRollbackFor().length > 0 || transactional.noRollbackForClassName().length > 0) {
                            if (Arrays.stream(transactional.noRollbackFor()).anyMatch(ex -> ex.isInstance(e)) || Arrays.stream(transactional.noRollbackForClassName()).anyMatch(exName -> exName.equals(e.getClass().getName()))) {
                                this.jdbcResource.getTransactionManager().commit(context);
                            } else {
                                this.jdbcResource.getTransactionManager().rollback(context);
                            }
                        } else if (transactional.rollbackFor().length > 0 || transactional.rollbackForClassName().length > 0) {
                            if (Arrays.stream(transactional.rollbackFor()).anyMatch(ex -> ex.isInstance(e)) || Arrays.stream(transactional.rollbackForClassName()).anyMatch(exName -> exName.equals(e.getClass().getName()))) {
                                this.jdbcResource.getTransactionManager().rollback(context);
                            } else {
                                this.jdbcResource.getTransactionManager().commit(context);
                            }
                        } else {
                            this.jdbcResource.getTransactionManager().rollback(context);
                        }
                    }
                    throw e;
                }
                finally {
                    this.jdbcResource.unbindDataSource();
                }
            };
        }
        if (retry != null) {
            SqlRetryCallProperties properties = new SqlRetryCallProperties().withCallerId(callerId).withLockInternally(retry.lockInternally()).withRetryOnDuplicateKey(retry.retryOnDuplicateKey());
            ThrowingSupplier toCall = functionToCall;
            SqlRetryFunction<Object> retryWrapper = () -> {
                try {
                    LOG.debug("Invoking method within retry context: {}", (Object)callerId);
                    Object result = toCall.execute();
                    LOG.debug("Successfull method invocation within retry context: {}", (Object)callerId);
                    return result;
                }
                catch (IllegalAccessException | InvocationTargetException | UndeclaredThrowableException e) {
                    if (e.getCause() instanceof TException) {
                        throw (TException)e.getCause();
                    }
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e);
                }
                catch (TException | DataAccessException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e);
                }
            };
            return this.sqlRetryHandler.executeWithRetry(properties, retryWrapper);
        }
        LOG.debug("Invoking method without retry context: {}", (Object)callerId);
        Object result = functionToCall.execute();
        LOG.debug("Successfull method invocation without retry context: {}", (Object)callerId);
        return result;
    }

    private static interface ThrowingSupplier {
        public Object execute() throws Throwable;
    }
}

