/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.tasks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasTask {
    @JsonIgnore
    public static final int MAX_ATTEMPT_COUNT = 3;
    private String type;
    private String guid;
    private String createdBy;
    private Date createdTime;
    private Date updatedTime;
    private Date startTime;
    private Date endTime;
    private Map<String, Object> parameters;
    private int attemptCount;
    private String errorMessage;
    private Status status;

    public AtlasTask() {
    }

    public AtlasTask(String type, String createdBy, Map<String, Object> parameters) {
        this.guid = UUID.randomUUID().toString();
        this.type = type;
        this.createdBy = createdBy;
        this.updatedTime = this.createdTime = new Date();
        this.parameters = parameters;
        this.status = Status.PENDING;
        this.attemptCount = 0;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Date updatedTime) {
        this.updatedTime = updatedTime;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> val) {
        this.parameters = val;
    }

    public void setType(String val) {
        this.type = val;
    }

    public String getType() {
        return this.type;
    }

    public void setStatus(String val) {
        if (StringUtils.isNotEmpty((String)val)) {
            this.status = Status.valueOf(val);
        }
    }

    public void setStatus(Status val) {
        this.status = val;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getAttemptCount() {
        return this.attemptCount;
    }

    public void setAttemptCount(int attemptCount) {
        this.attemptCount = attemptCount;
    }

    public void incrementAttemptCount() {
        ++this.attemptCount;
    }

    public void setStatusPending() {
        this.status = Status.PENDING;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @JsonIgnore
    public void start() {
        this.setStatus(Status.IN_PROGRESS);
        this.setStartTime(new Date());
    }

    @JsonIgnore
    public void end() {
        this.status = Status.COMPLETE;
        this.setEndTime(new Date());
    }

    @JsonIgnore
    public void updateStatusFromAttemptCount() {
        this.setStatus(this.attemptCount < 3 ? Status.PENDING : Status.FAILED);
    }

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

