/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.pruning;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.Serializable;
import org.apache.ignite.internal.sql.engine.prepare.pruning.PartitionPruningColumns;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class PartitionPruningMetadata
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final PartitionPruningMetadata EMPTY = new PartitionPruningMetadata((Long2ObjectMap<PartitionPruningColumns>)Long2ObjectMaps.emptyMap());
    private final Long2ObjectMap<PartitionPruningColumns> data;

    public PartitionPruningMetadata(Long2ObjectMap<PartitionPruningColumns> data) {
        LongIterator longIterator = data.keySet().iterator();
        while (longIterator.hasNext()) {
            long id = (Long)longIterator.next();
            if (id != -1L) continue;
            throw new IllegalArgumentException("sourceId has not been set: " + String.valueOf(data));
        }
        this.data = Long2ObjectMaps.unmodifiable(data);
    }

    @Nullable
    public PartitionPruningColumns get(long sourceId) {
        return (PartitionPruningColumns)this.data.get(sourceId);
    }

    public Long2ObjectMap<PartitionPruningColumns> data() {
        return this.data;
    }

    public String toString() {
        return S.toString(PartitionPruningMetadata.class, (Object)this, (String)"data", this.data);
    }

    public PartitionPruningMetadata subset(Long2ObjectMap<IgniteTable> tables) {
        Long2ObjectOpenHashMap out = new Long2ObjectOpenHashMap();
        for (Long2ObjectMap.Entry e : this.data.long2ObjectEntrySet()) {
            if (!tables.containsKey(e.getLongKey())) continue;
            out.put(e.getLongKey(), (Object)((PartitionPruningColumns)e.getValue()));
        }
        return new PartitionPruningMetadata((Long2ObjectMap<PartitionPruningColumns>)out);
    }
}

