/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.sessiondict.client;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.sessiondict.client.ISessionDictClient;
import org.apache.bifromq.sessiondict.client.ISessionRegistration;
import org.apache.bifromq.sessiondict.client.SessionRegister;
import org.apache.bifromq.type.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionRegistration
implements ISessionRegistration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionRegistration.class);
    private final AtomicReference<State> state;
    private final ClientInfo owner;
    private final SessionRegister register;

    SessionRegistration(ClientInfo owner, ISessionDictClient.IKillListener killListener, SessionRegister register) {
        this.owner = owner;
        this.register = register;
        this.state = new AtomicReference<State>(State.Registered);
        this.register.reg(owner, quit -> {
            if (log.isTraceEnabled()) {
                log.trace("Received quit request:reqId={},killer={}", (Object)quit.getReqId(), (Object)quit.getKiller());
            }
            killListener.onKill(quit.getKiller(), quit.getServerRedirection());
            this.state.set(State.Kicked);
            this.stop();
        });
        this.register.sendRegInfo(owner, true);
    }

    @Override
    public void stop() {
        if (this.state.get() == State.Quit) {
            return;
        }
        if (this.state.get() == State.Registered) {
            this.register.sendRegInfo(this.owner, false);
        }
        this.register.unreg(this.owner);
        this.state.set(State.Quit);
    }

    private static enum State {
        Registered,
        Kicked,
        Quit;

    }
}

