/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.bifromq.metrics.TenantMetric;

class TenantGauges {
    private static final ConcurrentMap<String, Map<TenantMetricKey, Gauge>> TENANT_GAUGES = new ConcurrentHashMap<String, Map<TenantMetricKey, Gauge>>();

    TenantGauges() {
    }

    static void gauging(String tenantId, TenantMetric gaugeMetric, Supplier<Number> supplier, String ... tagValuePair) {
        assert (gaugeMetric.meterType == Meter.Type.GAUGE);
        TENANT_GAUGES.compute(tenantId, (k, v) -> {
            if (v == null) {
                v = new HashMap<TenantMetricKey, Gauge>();
            }
            Tags tags = Tags.of((String[])tagValuePair);
            v.computeIfAbsent(new TenantMetricKey(gaugeMetric, tags), arg_0 -> TenantGauges.lambda$gauging$0(gaugeMetric, (Supplier)supplier, tags, tenantId, arg_0));
            return v;
        });
    }

    static void stopGauging(String tenantId, TenantMetric gaugeMetric, String ... tagValuePair) {
        assert (gaugeMetric.meterType == Meter.Type.GAUGE);
        TENANT_GAUGES.computeIfPresent(tenantId, (k, gaugeMap) -> {
            Tags tags = Tags.of((String[])tagValuePair);
            Gauge gauge = (Gauge)gaugeMap.remove(new TenantMetricKey(gaugeMetric, tags));
            if (gauge != null) {
                Metrics.globalRegistry.remove((Meter)gauge);
            }
            if (gaugeMap.isEmpty()) {
                return null;
            }
            return gaugeMap;
        });
    }

    private static /* synthetic */ Gauge lambda$gauging$0(TenantMetric gaugeMetric, Supplier supplier, Tags tags, String tenantId, TenantMetricKey tenantMetricKey) {
        return Gauge.builder((String)gaugeMetric.metricName, (Supplier)supplier).tags((Iterable)tags.and("tenantId", tenantId)).register((MeterRegistry)Metrics.globalRegistry);
    }

    private record TenantMetricKey(TenantMetric gaugeMetric, Tags tags) {
    }
}

