/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.utils;

import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import org.apache.bifromq.mqtt.utils.MQTT3MessageSizer;
import org.apache.bifromq.mqtt.utils.MQTT5MessageSizer;

public interface IMQTTMessageSizer {
    public static final int MIN_CONTROL_PACKET_SIZE = 16;
    public static final MqttMessageSize TWO_BYTES_REMAINING_LENGTH = new MqttMessageSize(){

        @Override
        public int encodedBytes() {
            return 4;
        }

        @Override
        public int encodedBytes(boolean includeUserProps, boolean includeReasonString) {
            return 4;
        }
    };
    public static final MqttMessageSize ZERO_BYTES_REMAINING_LENGTH = new MqttMessageSize(){

        @Override
        public int encodedBytes() {
            return 2;
        }

        @Override
        public int encodedBytes(boolean includeUserProps, boolean includeReasonString) {
            return 2;
        }
    };

    public static IMQTTMessageSizer mqtt3() {
        return MQTT3MessageSizer.INSTANCE;
    }

    public static IMQTTMessageSizer mqtt5() {
        return MQTT5MessageSizer.INSTANCE;
    }

    public static int sizeBinary(byte[] binary) {
        return 2 + binary.length;
    }

    public static int sizeUTF8EncodedString(String s) {
        int rsBytes = ByteBufUtil.utf8Bytes((CharSequence)s);
        return 2 + rsBytes;
    }

    public static int varIntBytes(int i) {
        int bytes = 0;
        do {
            int digit = i % 128;
            if ((i /= 128) > 0) {
                digit |= 0x80;
            }
            ++bytes;
        } while (i > 0);
        return bytes;
    }

    public MqttMessageSize sizeOf(MqttMessage var1);

    public int lastWillSize(MqttConnectMessage var1);

    default public int sizeByHeader(MqttFixedHeader header) {
        int remainingLength = header.remainingLength();
        int fixedHeaderSize = 1;
        int remainingLengthSize = 1;
        if (remainingLength > 127) {
            remainingLengthSize = 2;
            if (remainingLength > 16383) {
                remainingLengthSize = 3;
                if (remainingLength > 0x1FFFFF) {
                    remainingLengthSize = 4;
                }
            }
        }
        return fixedHeaderSize + remainingLengthSize + remainingLength;
    }

    public static interface MqttMessageSize {
        public int encodedBytes();

        public int encodedBytes(boolean var1, boolean var2);
    }
}

