/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.protobuf.Struct;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVStoreBalancerStatesReporter;
import org.apache.bifromq.basekv.proto.BalancerStateSnapshot;
import org.apache.bifromq.basekv.proto.StoreKey;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVStoreBalancerStatesReporter
implements IBaseKVStoreBalancerStatesReporter {
    private final Logger log;
    private final String storeId;
    private final IBaseKVStoreBalancerStatesCRDT statesCRDT;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private final Map<String, BalancerState> latestState = new ConcurrentHashMap<String, BalancerState>();

    BaseKVStoreBalancerStatesReporter(String storeId, IBaseKVStoreBalancerStatesCRDT statesCRDT) {
        this.log = MDCLogger.getLogger(BaseKVStoreBalancerStatesReporter.class, (String[])new String[]{"clusterId", statesCRDT.clusterId(), "storeId", storeId});
        this.storeId = storeId;
        this.statesCRDT = statesCRDT;
        this.disposable.add(statesCRDT.currentBalancerStates().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).subscribe(this::afterInflation));
    }

    @Override
    public CompletableFuture<Void> reportBalancerState(String balancerFactoryClassFQN, boolean disable, Struct loadRules) {
        Map<String, BalancerStateSnapshot> stateSnapshotMap = this.statesCRDT.getStoreBalancerStates(this.storeId);
        BalancerStateSnapshot stateSnapshot = stateSnapshotMap.get(balancerFactoryClassFQN);
        if (stateSnapshot == null || stateSnapshot.getDisable() != disable || !stateSnapshot.getLoadRules().equals((Object)loadRules)) {
            this.latestState.put(balancerFactoryClassFQN, new BalancerState(disable, loadRules));
            return this.statesCRDT.setStoreBalancerState(this.storeId, balancerFactoryClassFQN, disable, loadRules);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Observable<Long> refreshSignal() {
        return this.statesCRDT.refuteSignal();
    }

    @Override
    public void stop() {
        this.statesCRDT.removeStore(this.storeId).join();
        this.disposable.dispose();
    }

    private void afterInflation(Map<StoreKey, Map<String, BalancerStateSnapshot>> observed) {
        if (!observed.containsKey(this.statesCRDT.toDescriptorKey(this.storeId))) {
            this.log.debug("Rectify missing store balancer states");
            this.latestState.forEach((balancerClassFQN, balancerState) -> this.statesCRDT.setStoreBalancerState(this.storeId, (String)balancerClassFQN, balancerState.enable(), balancerState.loadRules()));
        }
    }

    private record BalancerState(boolean enable, Struct loadRules) {
    }
}

