/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dynamodbv2.model.ExportDescription;
import java.util.Date;

@SdkInternalApi
public class ExportDescriptionMarshaller {
    private static final MarshallingInfo<String> EXPORTARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportArn").build();
    private static final MarshallingInfo<String> EXPORTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportStatus").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> EXPORTMANIFEST_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportManifest").build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").build();
    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").build();
    private static final MarshallingInfo<Date> EXPORTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Bucket").build();
    private static final MarshallingInfo<String> S3BUCKETOWNER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketOwner").build();
    private static final MarshallingInfo<String> S3PREFIX_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Prefix").build();
    private static final MarshallingInfo<String> S3SSEALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3SseAlgorithm").build();
    private static final MarshallingInfo<String> S3SSEKMSKEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3SseKmsKeyId").build();
    private static final MarshallingInfo<String> FAILURECODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureCode").build();
    private static final MarshallingInfo<String> FAILUREMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureMessage").build();
    private static final MarshallingInfo<String> EXPORTFORMAT_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExportFormat").build();
    private static final MarshallingInfo<Long> BILLEDSIZEBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BilledSizeBytes").build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").build();
    private static final ExportDescriptionMarshaller instance = new ExportDescriptionMarshaller();

    public static ExportDescriptionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExportDescription exportDescription, ProtocolMarshaller protocolMarshaller) {
        if (exportDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(exportDescription.getExportArn(), EXPORTARN_BINDING);
            protocolMarshaller.marshall(exportDescription.getExportStatus(), EXPORTSTATUS_BINDING);
            protocolMarshaller.marshall(exportDescription.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(exportDescription.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(exportDescription.getExportManifest(), EXPORTMANIFEST_BINDING);
            protocolMarshaller.marshall(exportDescription.getTableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall(exportDescription.getTableId(), TABLEID_BINDING);
            protocolMarshaller.marshall(exportDescription.getExportTime(), EXPORTTIME_BINDING);
            protocolMarshaller.marshall(exportDescription.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall(exportDescription.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall(exportDescription.getS3BucketOwner(), S3BUCKETOWNER_BINDING);
            protocolMarshaller.marshall(exportDescription.getS3Prefix(), S3PREFIX_BINDING);
            protocolMarshaller.marshall(exportDescription.getS3SseAlgorithm(), S3SSEALGORITHM_BINDING);
            protocolMarshaller.marshall(exportDescription.getS3SseKmsKeyId(), S3SSEKMSKEYID_BINDING);
            protocolMarshaller.marshall(exportDescription.getFailureCode(), FAILURECODE_BINDING);
            protocolMarshaller.marshall(exportDescription.getFailureMessage(), FAILUREMESSAGE_BINDING);
            protocolMarshaller.marshall(exportDescription.getExportFormat(), EXPORTFORMAT_BINDING);
            protocolMarshaller.marshall(exportDescription.getBilledSizeBytes(), BILLEDSIZEBYTES_BINDING);
            protocolMarshaller.marshall(exportDescription.getItemCount(), ITEMCOUNT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

