/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class SnapshotCommands
extends FsCommand {
    private static final String CREATE_SNAPSHOT = "createSnapshot";
    private static final String DELETE_SNAPSHOT = "deleteSnapshot";
    private static final String RENAME_SNAPSHOT = "renameSnapshot";

    SnapshotCommands() {
    }

    public static void registerCommands(CommandFactory factory2) {
        factory2.addClass(CreateSnapshot.class, "-createSnapshot");
        factory2.addClass(DeleteSnapshot.class, "-deleteSnapshot");
        factory2.addClass(RenameSnapshot.class, "-renameSnapshot");
    }

    public static class RenameSnapshot
    extends FsCommand {
        public static final String NAME = "renameSnapshot";
        public static final String USAGE = "<snapshotDir> <oldName> <newName>";
        public static final String DESCRIPTION = "Rename a snapshot from oldName to newName";
        private String oldName;
        private String newName;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args2) throws IOException {
            if (args2.size() != 3) {
                throw new IllegalArgumentException("Incorrect number of arguments.");
            }
            this.newName = args2.removeLast();
            this.oldName = args2.removeLast();
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            Preconditions.checkArgument(items.size() == 1);
            PathData sroot = items.getFirst();
            sroot.fs.renameSnapshot(sroot.path, this.oldName, this.newName);
            this.out.println("Renamed snapshot " + this.oldName + " to " + this.newName + " under " + sroot.path);
        }
    }

    public static class DeleteSnapshot
    extends FsCommand {
        public static final String NAME = "deleteSnapshot";
        public static final String USAGE = "<snapshotDir> <snapshotName>";
        public static final String DESCRIPTION = "Delete a snapshot from a directory";
        private String snapshotName;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args2) throws IOException {
            if (args2.size() != 2) {
                throw new IllegalArgumentException("Incorrect number of arguments.");
            }
            this.snapshotName = args2.removeLast();
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            assert (items.size() == 1);
            PathData sroot = items.getFirst();
            sroot.fs.deleteSnapshot(sroot.path, this.snapshotName);
            this.out.println("Deleted snapshot " + this.snapshotName + " under " + sroot.path);
        }
    }

    public static class CreateSnapshot
    extends FsCommand {
        public static final String NAME = "createSnapshot";
        public static final String USAGE = "<snapshotDir> [<snapshotName>]";
        public static final String DESCRIPTION = "Create a snapshot on a directory";
        private String snapshotName = null;

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
        }

        @Override
        protected void processOptions(LinkedList<String> args2) throws IOException {
            if (args2.size() == 0) {
                throw new IllegalArgumentException("<snapshotDir> is missing.");
            }
            if (args2.size() > 2) {
                throw new IllegalArgumentException("Too many arguments.");
            }
            if (args2.size() == 2) {
                this.snapshotName = args2.removeLast();
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> items) throws IOException {
            super.processArguments(items);
            if (this.numErrors != 0) {
                return;
            }
            assert (items.size() == 1);
            PathData sroot = items.getFirst();
            Path snapshotPath = sroot.fs.createSnapshot(sroot.path, this.snapshotName);
            this.out.println("Created snapshot " + snapshotPath);
        }
    }
}

