/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.metrics.CharacterFilter;
import org.apache.fluss.metrics.Counter;
import org.apache.fluss.metrics.Gauge;
import org.apache.fluss.metrics.Histogram;
import org.apache.fluss.metrics.HistogramStatistics;
import org.apache.fluss.metrics.Meter;
import org.apache.fluss.metrics.Metric;
import org.apache.fluss.metrics.groups.MetricGroup;
import org.apache.fluss.metrics.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPrometheusReporter
implements MetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrometheusReporter.class);
    private static final Pattern UNALLOWED_CHAR_PATTERN = Pattern.compile("[^a-zA-Z0-9:_]");
    private static final CharacterFilter CHARACTER_FILTER = AbstractPrometheusReporter::replaceInvalidChars;
    @VisibleForTesting
    protected static final char SCOPE_SEPARATOR = '_';
    @VisibleForTesting
    protected static final String SCOPE_PREFIX = "fluss_";
    private final Map<String, AbstractMap.SimpleImmutableEntry<Collector, Integer>> collectorsWithCountByMetricName = new HashMap<String, AbstractMap.SimpleImmutableEntry<Collector, Integer>>();
    @VisibleForTesting
    protected final CollectorRegistry registry = new CollectorRegistry(true);

    protected static String replaceInvalidChars(String input) {
        return UNALLOWED_CHAR_PATTERN.matcher(input).replaceAll("_");
    }

    public void open(Configuration config) {
    }

    public void close() {
        this.registry.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        LinkedList<String> dimensionKeys = new LinkedList<String>();
        LinkedList<String> dimensionValues = new LinkedList<String>();
        for (Map.Entry dimension : group.getAllVariables().entrySet()) {
            dimensionKeys.add(CHARACTER_FILTER.filterCharacters((String)dimension.getKey()));
            dimensionValues.add(CHARACTER_FILTER.filterCharacters((String)dimension.getValue()));
        }
        String scopedMetricName = AbstractPrometheusReporter.getScopedName(metricName, group);
        String helpString = metricName + " (scope: " + AbstractPrometheusReporter.getLogicalScope(group) + ")";
        Integer count = 0;
        AbstractPrometheusReporter abstractPrometheusReporter = this;
        synchronized (abstractPrometheusReporter) {
            Collector collector;
            if (this.collectorsWithCountByMetricName.containsKey(scopedMetricName)) {
                AbstractMap.SimpleImmutableEntry<Collector, Integer> collectorWithCount = this.collectorsWithCountByMetricName.get(scopedMetricName);
                collector = collectorWithCount.getKey();
                count = collectorWithCount.getValue();
            } else {
                collector = this.createCollector(metric, dimensionKeys, dimensionValues, scopedMetricName, helpString);
                try {
                    collector.register(this.registry);
                }
                catch (Exception e) {
                    LOG.warn("There was a problem registering metric {}.", (Object)metricName, (Object)e);
                }
            }
            this.addMetric(metric, dimensionValues, collector);
            this.collectorsWithCountByMetricName.put(scopedMetricName, new AbstractMap.SimpleImmutableEntry<Collector, Integer>(collector, count + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        LinkedList<String> dimensionValues = new LinkedList<String>();
        for (Map.Entry dimension : group.getAllVariables().entrySet()) {
            dimensionValues.add(CHARACTER_FILTER.filterCharacters((String)dimension.getValue()));
        }
        String scopedMetricName = AbstractPrometheusReporter.getScopedName(metricName, group);
        AbstractPrometheusReporter abstractPrometheusReporter = this;
        synchronized (abstractPrometheusReporter) {
            AbstractMap.SimpleImmutableEntry<Collector, Integer> collectorWithCount = this.collectorsWithCountByMetricName.get(scopedMetricName);
            Integer count = collectorWithCount.getValue();
            Collector collector = collectorWithCount.getKey();
            this.removeMetric(metric, dimensionValues, collector);
            if (count == 1) {
                try {
                    this.registry.unregister(collector);
                }
                catch (Exception e) {
                    LOG.warn("There was a problem unregistering metric {}.", (Object)scopedMetricName, (Object)e);
                }
                this.collectorsWithCountByMetricName.remove(scopedMetricName);
            } else {
                this.collectorsWithCountByMetricName.put(scopedMetricName, new AbstractMap.SimpleImmutableEntry<Collector, Integer>(collector, count - 1));
            }
        }
    }

    protected static String getScopedName(String metricName, MetricGroup group) {
        return SCOPE_PREFIX + AbstractPrometheusReporter.getLogicalScope(group) + "_" + CHARACTER_FILTER.filterCharacters(metricName);
    }

    protected static String getLogicalScope(MetricGroup group) {
        return group.getLogicalScope(CHARACTER_FILTER, '_');
    }

    protected Collector createCollector(Metric metric, List<String> dimensionKeys, List<String> dimensionValues, String scopedMetricName, String helpString) {
        Collector collector;
        switch (metric.getMetricType()) {
            case GAUGE: 
            case COUNTER: 
            case METER: {
                collector = ((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)io.prometheus.client.Gauge.build().name(scopedMetricName)).help(helpString)).labelNames(AbstractPrometheusReporter.toArray(dimensionKeys))).create();
                break;
            }
            case HISTOGRAM: {
                collector = new HistogramSummaryProxy((Histogram)metric, scopedMetricName, helpString, dimensionKeys, dimensionValues);
                break;
            }
            default: {
                LOG.warn("Cannot create collector for unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
                collector = null;
            }
        }
        return collector;
    }

    protected void addMetric(Metric metric, List<String> dimensionValues, Collector collector) {
        switch (metric.getMetricType()) {
            case GAUGE: {
                ((io.prometheus.client.Gauge)collector).setChild(AbstractPrometheusReporter.gaugeFrom((Gauge)metric), AbstractPrometheusReporter.toArray(dimensionValues));
                break;
            }
            case COUNTER: {
                ((io.prometheus.client.Gauge)collector).setChild(AbstractPrometheusReporter.gaugeFrom((Counter)metric), AbstractPrometheusReporter.toArray(dimensionValues));
                break;
            }
            case METER: {
                ((io.prometheus.client.Gauge)collector).setChild(AbstractPrometheusReporter.gaugeFrom((Meter)metric), AbstractPrometheusReporter.toArray(dimensionValues));
                break;
            }
            case HISTOGRAM: {
                ((HistogramSummaryProxy)collector).addChild((Histogram)metric, dimensionValues);
                break;
            }
            default: {
                LOG.warn("Cannot add unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
            }
        }
    }

    protected void removeMetric(Metric metric, List<String> dimensionValues, Collector collector) {
        switch (metric.getMetricType()) {
            case GAUGE: 
            case COUNTER: 
            case METER: {
                ((io.prometheus.client.Gauge)collector).remove(AbstractPrometheusReporter.toArray(dimensionValues));
                break;
            }
            case HISTOGRAM: {
                ((HistogramSummaryProxy)collector).remove(dimensionValues);
                break;
            }
            default: {
                LOG.warn("Cannot remove unknown metric type: {}. This indicates that the metric type is not supported by this reporter.", (Object)metric.getClass().getName());
            }
        }
    }

    protected static Gauge.Child gaugeFrom(final Gauge<?> gauge) {
        return new Gauge.Child(){

            @Override
            public double get() {
                Object value = gauge.getValue();
                if (value == null) {
                    LOG.debug("Gauge {} is null-valued, defaulting to 0.", (Object)gauge);
                    return 0.0;
                }
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1.0 : 0.0;
                }
                LOG.debug("Invalid type for Gauge {}: {}, only number types and booleans are supported by this reporter.", (Object)gauge, (Object)value.getClass().getName());
                return 0.0;
            }
        };
    }

    protected static Gauge.Child gaugeFrom(final Counter counter) {
        return new Gauge.Child(){

            @Override
            public double get() {
                return counter.getCount();
            }
        };
    }

    protected static Gauge.Child gaugeFrom(final Meter meter) {
        return new Gauge.Child(){

            @Override
            public double get() {
                return meter.getRate();
            }
        };
    }

    protected static List<String> addToList(List<String> list, String element) {
        ArrayList<String> result = new ArrayList<String>(list);
        result.add(element);
        return result;
    }

    protected static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    @VisibleForTesting
    static class HistogramSummaryProxy
    extends Collector {
        static final List<Double> QUANTILES = Arrays.asList(0.5, 0.75, 0.95, 0.98, 0.99, 0.999);
        private final String metricName;
        private final String helpString;
        private final List<String> labelNamesWithQuantile;
        private final Map<List<String>, Histogram> histogramsByLabelValues = new HashMap<List<String>, Histogram>();

        HistogramSummaryProxy(Histogram histogram, String metricName, String helpString, List<String> labelNames, List<String> labelValues) {
            this.metricName = metricName;
            this.helpString = helpString;
            this.labelNamesWithQuantile = AbstractPrometheusReporter.addToList(labelNames, "quantile");
            this.histogramsByLabelValues.put(labelValues, histogram);
        }

        @Override
        public List<Collector.MetricFamilySamples> collect() {
            LinkedList<Collector.MetricFamilySamples.Sample> samples = new LinkedList<Collector.MetricFamilySamples.Sample>();
            for (Map.Entry<List<String>, Histogram> labelValuesToHistogram : this.histogramsByLabelValues.entrySet()) {
                this.addSamples(labelValuesToHistogram.getKey(), labelValuesToHistogram.getValue(), samples);
            }
            return Collections.singletonList(new Collector.MetricFamilySamples(this.metricName, Collector.Type.SUMMARY, this.helpString, samples));
        }

        void addChild(Histogram histogram, List<String> labelValues) {
            this.histogramsByLabelValues.put(labelValues, histogram);
        }

        void remove(List<String> labelValues) {
            this.histogramsByLabelValues.remove(labelValues);
        }

        private void addSamples(List<String> labelValues, Histogram histogram, List<Collector.MetricFamilySamples.Sample> samples) {
            samples.add(new Collector.MetricFamilySamples.Sample(this.metricName + "_count", this.labelNamesWithQuantile.subList(0, this.labelNamesWithQuantile.size() - 1), labelValues, histogram.getCount()));
            HistogramStatistics statistics = histogram.getStatistics();
            for (Double quantile : QUANTILES) {
                samples.add(new Collector.MetricFamilySamples.Sample(this.metricName, this.labelNamesWithQuantile, AbstractPrometheusReporter.addToList(labelValues, quantile.toString()), statistics.getQuantile(quantile.doubleValue())));
            }
        }
    }
}

