/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractDelegationTokenSecretManager<TokenIdent extends AbstractDelegationTokenIdentifier>
extends SecretManager<TokenIdent> {
    private static final Log LOG = LogFactory.getLog(AbstractDelegationTokenSecretManager.class);
    protected final Map<TokenIdent, DelegationTokenInformation> currentTokens = new HashMap<TokenIdent, DelegationTokenInformation>();
    protected int delegationTokenSequenceNumber = 0;
    protected final Map<Integer, DelegationKey> allKeys = new HashMap<Integer, DelegationKey>();
    protected int currentId = 0;
    private DelegationKey currentKey;
    private long keyUpdateInterval;
    private long tokenMaxLifetime;
    private long tokenRemoverScanInterval;
    private long tokenRenewInterval;
    protected boolean storeTokenTrackingId;
    private Thread tokenRemoverThread;
    protected volatile boolean running;
    protected Object noInterruptsLock = new Object();

    private String formatTokenId(TokenIdent id) {
        return "(" + id + ")";
    }

    public AbstractDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval) {
        this.keyUpdateInterval = delegationKeyUpdateInterval;
        this.tokenMaxLifetime = delegationTokenMaxLifetime;
        this.tokenRenewInterval = delegationTokenRenewInterval;
        this.tokenRemoverScanInterval = delegationTokenRemoverScanInterval;
        this.storeTokenTrackingId = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThreads() throws IOException {
        Preconditions.checkState(!this.running);
        this.updateCurrentKey();
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            this.running = true;
            this.tokenRemoverThread = new Daemon(new ExpiredTokenRemover());
            this.tokenRemoverThread.start();
        }
    }

    public synchronized void reset() {
        this.setCurrentKeyId(0);
        this.allKeys.clear();
        this.setDelegationTokenSeqNum(0);
        this.currentTokens.clear();
    }

    public synchronized void addKey(DelegationKey key) throws IOException {
        if (this.running) {
            throw new IOException("Can't add delegation key to a running SecretManager.");
        }
        if (key.getKeyId() > this.getCurrentKeyId()) {
            this.setCurrentKeyId(key.getKeyId());
        }
        this.allKeys.put(key.getKeyId(), key);
    }

    public synchronized DelegationKey[] getAllKeys() {
        return this.allKeys.values().toArray(new DelegationKey[0]);
    }

    protected void logUpdateMasterKey(DelegationKey key) throws IOException {
    }

    protected void logExpireToken(TokenIdent ident) throws IOException {
    }

    protected void storeNewMasterKey(DelegationKey key) throws IOException {
    }

    protected void removeStoredMasterKey(DelegationKey key) {
    }

    protected void storeNewToken(TokenIdent ident, long renewDate) throws IOException {
    }

    protected void removeStoredToken(TokenIdent ident) throws IOException {
    }

    protected void updateStoredToken(TokenIdent ident, long renewDate) throws IOException {
    }

    protected synchronized int getCurrentKeyId() {
        return this.currentId;
    }

    protected synchronized int incrementCurrentKeyId() {
        return ++this.currentId;
    }

    protected synchronized void setCurrentKeyId(int keyId) {
        this.currentId = keyId;
    }

    protected synchronized int getDelegationTokenSeqNum() {
        return this.delegationTokenSequenceNumber;
    }

    protected synchronized int incrementDelegationTokenSeqNum() {
        return ++this.delegationTokenSequenceNumber;
    }

    protected synchronized void setDelegationTokenSeqNum(int seqNum) {
        this.delegationTokenSequenceNumber = seqNum;
    }

    protected DelegationKey getDelegationKey(int keyId) {
        return this.allKeys.get(keyId);
    }

    protected void storeDelegationKey(DelegationKey key) throws IOException {
        this.allKeys.put(key.getKeyId(), key);
        this.storeNewMasterKey(key);
    }

    protected void updateDelegationKey(DelegationKey key) throws IOException {
        this.allKeys.put(key.getKeyId(), key);
    }

    protected DelegationTokenInformation getTokenInfo(TokenIdent ident) {
        return this.currentTokens.get(ident);
    }

    protected void storeToken(TokenIdent ident, DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(ident, tokenInfo);
        this.storeNewToken(ident, tokenInfo.getRenewDate());
    }

    protected void updateToken(TokenIdent ident, DelegationTokenInformation tokenInfo) throws IOException {
        this.currentTokens.put(ident, tokenInfo);
        this.updateStoredToken(ident, tokenInfo.getRenewDate());
    }

    public synchronized void addPersistedDelegationToken(TokenIdent identifier, long renewDate) throws IOException {
        if (this.running) {
            throw new IOException("Can't add persisted delegation token to a running SecretManager.");
        }
        int keyId = ((AbstractDelegationTokenIdentifier)identifier).getMasterKeyId();
        DelegationKey dKey = this.allKeys.get(keyId);
        if (dKey == null) {
            LOG.warn("No KEY found for persisted identifier " + this.formatTokenId(identifier));
            return;
        }
        byte[] password = AbstractDelegationTokenSecretManager.createPassword(((TokenIdentifier)identifier).getBytes(), dKey.getKey());
        if (((AbstractDelegationTokenIdentifier)identifier).getSequenceNumber() > this.getDelegationTokenSeqNum()) {
            this.setDelegationTokenSeqNum(((AbstractDelegationTokenIdentifier)identifier).getSequenceNumber());
        }
        if (this.getTokenInfo(identifier) != null) {
            throw new IOException("Same delegation token being added twice: " + this.formatTokenId(identifier));
        }
        this.currentTokens.put(identifier, new DelegationTokenInformation(renewDate, password, this.getTrackingIdIfEnabled(identifier)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentKey() throws IOException {
        int newCurrentId;
        LOG.info("Updating the current master key for generating delegation tokens");
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            newCurrentId = this.incrementCurrentKeyId();
        }
        DelegationKey newKey = new DelegationKey(newCurrentId, System.currentTimeMillis() + this.keyUpdateInterval + this.tokenMaxLifetime, this.generateSecret());
        this.logUpdateMasterKey(newKey);
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager2 = this;
        synchronized (abstractDelegationTokenSecretManager2) {
            this.currentKey = newKey;
            this.storeDelegationKey(this.currentKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollMasterKey() throws IOException {
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            this.removeExpiredKeys();
            this.currentKey.setExpiryDate(Time.now() + this.tokenMaxLifetime);
            this.updateDelegationKey(this.currentKey);
        }
        this.updateCurrentKey();
    }

    private synchronized void removeExpiredKeys() {
        long now = Time.now();
        Iterator<Map.Entry<Integer, DelegationKey>> it = this.allKeys.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, DelegationKey> e = it.next();
            if (e.getValue().getExpiryDate() >= now) continue;
            it.remove();
            if (e.getValue().equals(this.currentKey)) continue;
            this.removeStoredMasterKey(e.getValue());
        }
    }

    @Override
    protected synchronized byte[] createPassword(TokenIdent identifier) {
        long now = Time.now();
        int sequenceNum = this.incrementDelegationTokenSeqNum();
        ((AbstractDelegationTokenIdentifier)identifier).setIssueDate(now);
        ((AbstractDelegationTokenIdentifier)identifier).setMaxDate(now + this.tokenMaxLifetime);
        ((AbstractDelegationTokenIdentifier)identifier).setMasterKeyId(this.currentKey.getKeyId());
        ((AbstractDelegationTokenIdentifier)identifier).setSequenceNumber(sequenceNum);
        LOG.info("Creating password for identifier: " + this.formatTokenId(identifier) + ", currentKey: " + this.currentKey.getKeyId());
        byte[] password = AbstractDelegationTokenSecretManager.createPassword(((TokenIdentifier)identifier).getBytes(), this.currentKey.getKey());
        DelegationTokenInformation tokenInfo = new DelegationTokenInformation(now + this.tokenRenewInterval, password, this.getTrackingIdIfEnabled(identifier));
        try {
            this.storeToken(identifier, tokenInfo);
        }
        catch (IOException ioe) {
            LOG.error("Could not store token " + this.formatTokenId(identifier) + "!!", ioe);
        }
        return password;
    }

    protected DelegationTokenInformation checkToken(TokenIdent identifier) throws SecretManager.InvalidToken {
        assert (Thread.holdsLock(this));
        DelegationTokenInformation info = this.getTokenInfo(identifier);
        if (info == null) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " can't be found in cache");
        }
        long now = Time.now();
        if (info.getRenewDate() < now) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " is " + "expired, current time: " + Time.formatTime(now) + " expected renewal time: " + Time.formatTime(info.getRenewDate()));
        }
        return info;
    }

    @Override
    public synchronized byte[] retrievePassword(TokenIdent identifier) throws SecretManager.InvalidToken {
        return this.checkToken(identifier).getPassword();
    }

    protected String getTrackingIdIfEnabled(TokenIdent ident) {
        if (this.storeTokenTrackingId) {
            return ((TokenIdentifier)ident).getTrackingId();
        }
        return null;
    }

    public synchronized String getTokenTrackingId(TokenIdent identifier) {
        DelegationTokenInformation info = this.getTokenInfo(identifier);
        if (info == null) {
            return null;
        }
        return info.getTrackingId();
    }

    public synchronized void verifyToken(TokenIdent identifier, byte[] password) throws SecretManager.InvalidToken {
        byte[] storedPassword = this.retrievePassword(identifier);
        if (!MessageDigest.isEqual(password, storedPassword)) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " is invalid, password doesn't match");
        }
    }

    public synchronized long renewToken(Token<TokenIdent> token, String renewer) throws SecretManager.InvalidToken, IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        id.readFields(in);
        LOG.info("Token renewal for identifier: " + this.formatTokenId(id) + "; total currentTokens " + this.currentTokens.size());
        long now = Time.now();
        if (id.getMaxDate() < now) {
            throw new SecretManager.InvalidToken(renewer + " tried to renew an expired token " + this.formatTokenId(id) + " max expiration date: " + Time.formatTime(id.getMaxDate()) + " currentTime: " + Time.formatTime(now));
        }
        if (id.getRenewer() == null || id.getRenewer().toString().isEmpty()) {
            throw new AccessControlException(renewer + " tried to renew a token " + this.formatTokenId(id) + " without a renewer");
        }
        if (!id.getRenewer().toString().equals(renewer)) {
            throw new AccessControlException(renewer + " tries to renew a token " + this.formatTokenId(id) + " with non-matching renewer " + id.getRenewer());
        }
        DelegationKey key = this.getDelegationKey(id.getMasterKeyId());
        if (key == null) {
            throw new SecretManager.InvalidToken("Unable to find master key for keyId=" + id.getMasterKeyId() + " from cache. Failed to renew an unexpired token " + this.formatTokenId(id) + " with sequenceNumber=" + id.getSequenceNumber());
        }
        byte[] password = AbstractDelegationTokenSecretManager.createPassword(token.getIdentifier(), key.getKey());
        if (!MessageDigest.isEqual(password, token.getPassword())) {
            throw new AccessControlException(renewer + " is trying to renew a token " + this.formatTokenId(id) + " with wrong password");
        }
        long renewTime = Math.min(id.getMaxDate(), now + this.tokenRenewInterval);
        String trackingId = this.getTrackingIdIfEnabled(id);
        DelegationTokenInformation info = new DelegationTokenInformation(renewTime, password, trackingId);
        if (this.getTokenInfo(id) == null) {
            throw new SecretManager.InvalidToken("Renewal request for unknown token " + this.formatTokenId(id));
        }
        this.updateToken(id, info);
        return renewTime;
    }

    public synchronized TokenIdent cancelToken(Token<TokenIdent> token, String canceller) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        AbstractDelegationTokenIdentifier id = (AbstractDelegationTokenIdentifier)this.createIdentifier();
        id.readFields(in);
        LOG.info("Token cancellation requested for identifier: " + this.formatTokenId(id));
        if (id.getUser() == null) {
            throw new SecretManager.InvalidToken("Token with no owner " + this.formatTokenId(id));
        }
        String owner = id.getUser().getUserName();
        Text renewer = id.getRenewer();
        HadoopKerberosName cancelerKrbName = new HadoopKerberosName(canceller);
        String cancelerShortName = cancelerKrbName.getShortName();
        if (!(canceller.equals(owner) || renewer != null && !renewer.toString().isEmpty() && cancelerShortName.equals(renewer.toString()))) {
            throw new AccessControlException(canceller + " is not authorized to cancel the token " + this.formatTokenId(id));
        }
        DelegationTokenInformation info = this.currentTokens.remove(id);
        if (info == null) {
            throw new SecretManager.InvalidToken("Token not found " + this.formatTokenId(id));
        }
        this.removeStoredToken(id);
        return (TokenIdent)id;
    }

    public static SecretKey createSecretKey(byte[] key) {
        return SecretManager.createSecretKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredToken() throws IOException {
        long now = Time.now();
        HashSet<TokenIdent> expiredTokens = new HashSet<TokenIdent>();
        AbstractDelegationTokenSecretManager abstractDelegationTokenSecretManager = this;
        synchronized (abstractDelegationTokenSecretManager) {
            Iterator<Map.Entry<TokenIdent, DelegationTokenInformation>> i = this.currentTokens.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<TokenIdent, DelegationTokenInformation> entry = i.next();
                long renewDate = entry.getValue().getRenewDate();
                if (renewDate >= now) continue;
                expiredTokens.add(entry.getKey());
                i.remove();
            }
        }
        for (AbstractDelegationTokenIdentifier ident : expiredTokens) {
            this.logExpireToken(ident);
            this.removeStoredToken(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping expired delegation token remover thread");
        }
        this.running = false;
        if (this.tokenRemoverThread != null) {
            Object object = this.noInterruptsLock;
            synchronized (object) {
                this.tokenRemoverThread.interrupt();
            }
            try {
                this.tokenRemoverThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to join on token removal thread", e);
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public TokenIdent decodeTokenIdentifier(Token<TokenIdent> token) throws IOException {
        return (TokenIdent)((AbstractDelegationTokenIdentifier)token.decodeIdentifier());
    }

    private class ExpiredTokenRemover
    extends Thread {
        private long lastMasterKeyUpdate;
        private long lastTokenCacheCleanup;

        private ExpiredTokenRemover() {
        }

        @Override
        public void run() {
            LOG.info("Starting expired delegation token remover thread, tokenRemoverScanInterval=" + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval / 60000L + " min(s)");
            block6: while (true) {
                try {
                    while (AbstractDelegationTokenSecretManager.this.running) {
                        long now = Time.now();
                        if (this.lastMasterKeyUpdate + AbstractDelegationTokenSecretManager.this.keyUpdateInterval < now) {
                            try {
                                AbstractDelegationTokenSecretManager.this.rollMasterKey();
                                this.lastMasterKeyUpdate = now;
                            }
                            catch (IOException e) {
                                LOG.error("Master key updating failed: ", e);
                            }
                        }
                        if (this.lastTokenCacheCleanup + AbstractDelegationTokenSecretManager.this.tokenRemoverScanInterval < now) {
                            AbstractDelegationTokenSecretManager.this.removeExpiredToken();
                            this.lastTokenCacheCleanup = now;
                        }
                        try {
                            Thread.sleep(Math.min(5000L, AbstractDelegationTokenSecretManager.this.keyUpdateInterval));
                            continue block6;
                        }
                        catch (InterruptedException ie) {
                            LOG.error("ExpiredTokenRemover received " + ie);
                        }
                    }
                    break;
                }
                catch (Throwable t) {
                    LOG.error("ExpiredTokenRemover thread received unexpected exception", t);
                    Runtime.getRuntime().exit(-1);
                    break;
                }
            }
        }
    }

    @InterfaceStability.Evolving
    public static class DelegationTokenInformation {
        long renewDate;
        byte[] password;
        String trackingId;

        public DelegationTokenInformation(long renewDate, byte[] password) {
            this(renewDate, password, null);
        }

        public DelegationTokenInformation(long renewDate, byte[] password, String trackingId) {
            this.renewDate = renewDate;
            this.password = password;
            this.trackingId = trackingId;
        }

        public long getRenewDate() {
            return this.renewDate;
        }

        byte[] getPassword() {
            return this.password;
        }

        public String getTrackingId() {
            return this.trackingId;
        }
    }
}

