/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mimetypes {
    private static final Log log = LogFactory.getLog(Mimetypes.class);
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_BINARY_OCTET_STREAM = "binary/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    @Deprecated
    public static final String MIMETYPE_JETS3T_DIRECTORY = "application/x-directory";
    private static Mimetypes mimetypes = null;
    private final Map<String, String> extensionToMimetypeMap = new HashMap<String, String>();

    private Mimetypes() {
    }

    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream mimetypesFile = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (mimetypesFile != null) {
            if (log.isDebugEnabled()) {
                log.debug("Loading mime types from file in the classpath: mime.types");
            }
            try {
                mimetypes.loadAndReplaceMimetypes(mimetypesFile);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error("Failed to load mime types from file in the classpath: mime.types", e);
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Unable to find 'mime.types' file in classpath");
        }
        return mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (st.countTokens() > 1) {
                String mimetype = st.nextToken();
                while (st.hasMoreTokens()) {
                    String extension = st.nextToken();
                    this.extensionToMimetypeMap.put(extension, mimetype);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Setting mime type for extension '" + extension + "' to '" + mimetype + "'");
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Ignoring mimetype with no associated file extensions: '" + line + "'");
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex;
        String mimetype = this.extensionToMimetypeMap.get("*");
        if (mimetype == null) {
            mimetype = MIMETYPE_OCTET_STREAM;
        }
        if ((lastPeriodIndex = fileName.lastIndexOf(".")) > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1);
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                mimetype = this.extensionToMimetypeMap.get(ext);
                if (log.isDebugEnabled()) {
                    log.debug("Recognised extension '" + ext + "', mimetype is: '" + mimetype + "'");
                }
                return mimetype;
            }
            if (log.isDebugEnabled()) {
                log.debug("Extension '" + ext + "' is unrecognized in mime type listing" + ", using default mime type: '" + mimetype + "'");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("File name has no extension, mime type cannot be recognised for: " + fileName);
        }
        return mimetype;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

