/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.PacketLogger;
import org.xbill.DNS.utils.hexdump;

public abstract class NioClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NioClient.class);
    private static PacketLogger packetLogger = null;
    private static final List<Runnable> timeoutTasks = new CopyOnWriteArrayList<Runnable>();
    private static final List<Runnable> closeTasks = new CopyOnWriteArrayList<Runnable>();
    private static Thread selectorThread;
    private static Thread closeThread;
    private static volatile Selector selector;
    private static volatile boolean run;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Selector selector() throws IOException {
        if (selector != null) return selector;
        Class<NioClient> clazz = NioClient.class;
        synchronized (NioClient.class) {
            if (selector != null) return selector;
            selector = Selector.open();
            log.debug("Starting dnsjava NIO selector thread");
            run = true;
            selectorThread = new Thread(NioClient::runSelector);
            selectorThread.setDaemon(true);
            selectorThread.setName("dnsjava NIO selector");
            selectorThread.start();
            closeThread = new Thread(() -> NioClient.close(true));
            closeThread.setName("dnsjava NIO shutdown hook");
            Runtime.getRuntime().addShutdownHook(closeThread);
            // ** MonitorExit[var0] (shouldn't be in output)
            return selector;
        }
    }

    public static void close() {
        NioClient.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(boolean fromHook) {
        run = false;
        if (!fromHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(closeThread);
            }
            catch (Exception ex) {
                log.warn("Failed to remove shutdown hoook, ignoring and continuing close");
            }
        }
        for (Runnable closeTask : closeTasks) {
            try {
                closeTask.run();
            }
            catch (Exception e) {
                log.warn("Failed to execute a shutdown task, ignoring and continuing close", (Throwable)e);
            }
        }
        selector.wakeup();
        try {
            selector.close();
        }
        catch (IOException e) {
            log.warn("Failed to properly close selector, ignoring and continuing close", (Throwable)e);
        }
        try {
            selectorThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            Class<NioClient> clazz = NioClient.class;
            synchronized (NioClient.class) {
                selector = null;
                selectorThread = null;
                closeThread = null;
                // ** MonitorExit[var1_5] (shouldn't be in output)
            }
        }
    }

    private static void runSelector() {
        while (run) {
            try {
                if (selector.select(1000L) == 0) {
                    timeoutTasks.forEach(Runnable::run);
                }
                if (!run) continue;
                NioClient.processReadyKeys();
            }
            catch (IOException e) {
                log.error("A selection operation failed", (Throwable)e);
            }
            catch (ClosedSelectorException closedSelectorException) {}
        }
        log.debug("dnsjava NIO selector thread stopped");
    }

    static void addSelectorTimeoutTask(Runnable r) {
        timeoutTasks.add(r);
    }

    static void addCloseTask(Runnable r) {
        closeTasks.add(r);
    }

    private static void processReadyKeys() {
        Iterator<SelectionKey> it = selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            KeyProcessor t2 = (KeyProcessor)key.attachment();
            t2.processReadyKey(key);
        }
    }

    static void verboseLog(String prefix, SocketAddress local, SocketAddress remote, byte[] data) {
        if (log.isTraceEnabled()) {
            log.trace(hexdump.dump(prefix, data));
        }
        if (packetLogger != null) {
            packetLogger.log(prefix, local, remote, data);
        }
    }

    static void setPacketLogger(PacketLogger logger) {
        packetLogger = logger;
    }

    static interface KeyProcessor {
        public void processReadyKey(SelectionKey var1);
    }
}

