/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import org.apache.fluss.lake.paimon.PaimonLakeCatalog;
import org.apache.fluss.lake.paimon.source.FlussRowAsPaimonRow;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.record.LogRecord;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class FlussRecordAsPaimonRow
extends FlussRowAsPaimonRow {
    private final int bucket;
    private LogRecord logRecord;
    private int originRowFieldCount;
    private final int businessFieldCount;
    private final int bucketFieldIndex;
    private final int offsetFieldIndex;
    private final int timestampFieldIndex;

    public FlussRecordAsPaimonRow(int bucket, RowType tableTowType) {
        super(tableTowType);
        this.bucket = bucket;
        this.bucketFieldIndex = this.businessFieldCount = this.tableRowType.getFieldCount() - PaimonLakeCatalog.SYSTEM_COLUMNS.size();
        this.offsetFieldIndex = this.businessFieldCount + 1;
        this.timestampFieldIndex = this.businessFieldCount + 2;
    }

    public void setFlussRecord(LogRecord logRecord) {
        this.logRecord = logRecord;
        this.internalRow = logRecord.getRow();
        int flussFieldCount = this.internalRow.getFieldCount();
        if (flussFieldCount > this.businessFieldCount) {
            throw new IllegalStateException(String.format("Fluss record has %d fields but Paimon schema only has %d business fields. This indicates the lake schema is not yet synchronized. Please retry the schema change operation.", flussFieldCount, this.businessFieldCount));
        }
        this.originRowFieldCount = flussFieldCount;
    }

    @Override
    public int getFieldCount() {
        return this.tableRowType.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return PaimonConversions.toRowKind(this.logRecord.getChangeType());
    }

    @Override
    public boolean isNullAt(int pos) {
        if (pos < this.originRowFieldCount) {
            return super.isNullAt(pos);
        }
        return pos < this.businessFieldCount;
    }

    @Override
    public int getInt(int pos) {
        if (pos == this.bucketFieldIndex) {
            return this.bucket;
        }
        if (pos >= this.originRowFieldCount) {
            throw new IllegalStateException(String.format("Field %s is NULL because Paimon schema is wider than Fluss record.", pos));
        }
        return super.getInt(pos);
    }

    @Override
    public long getLong(int pos) {
        if (pos == this.offsetFieldIndex) {
            return this.logRecord.logOffset();
        }
        if (pos == this.timestampFieldIndex) {
            return this.logRecord.timestamp();
        }
        if (pos >= this.originRowFieldCount) {
            throw new IllegalStateException(String.format("Field %s is NULL because Paimon schema is wider than Fluss record.", pos));
        }
        return super.getLong(pos);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        if (pos == this.timestampFieldIndex) {
            return Timestamp.fromEpochMillis((long)this.logRecord.timestamp());
        }
        if (pos >= this.originRowFieldCount) {
            throw new IllegalStateException(String.format("Field %s is NULL because Paimon schema is wider than Fluss record.", pos));
        }
        return super.getTimestamp(pos, precision);
    }
}

