/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.fluss.config.ConfigOptions;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.lake.committer.CommittedLakeSnapshot;
import org.apache.fluss.lake.committer.CommitterInitContext;
import org.apache.fluss.lake.committer.LakeCommitResult;
import org.apache.fluss.lake.committer.LakeCommitter;
import org.apache.fluss.lake.paimon.tiering.PaimonCatalogProvider;
import org.apache.fluss.lake.paimon.tiering.PaimonCommittable;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResult;
import org.apache.fluss.lake.paimon.utils.DvTableReadableSnapshotRetriever;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.utils.Preconditions;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonLakeCommitter
implements LakeCommitter<PaimonWriteResult, PaimonCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(PaimonLakeCommitter.class);
    private final Catalog paimonCatalog;
    private final FileStoreTable fileStoreTable;
    private final TablePath tablePath;
    private final long tableId;
    private final Configuration flussClientConfig;
    private TableCommitImpl tableCommit;
    private static final ThreadLocal<Long> currentCommitSnapshotId = new ThreadLocal();

    public PaimonLakeCommitter(PaimonCatalogProvider paimonCatalogProvider, CommitterInitContext committerInitContext) throws IOException {
        this.paimonCatalog = paimonCatalogProvider.get();
        this.tablePath = committerInitContext.tablePath();
        this.tableId = committerInitContext.tableInfo().getTableId();
        this.flussClientConfig = committerInitContext.flussClientConfig();
        this.fileStoreTable = this.getTable(committerInitContext.tablePath(), committerInitContext.tableInfo().getTableConfig().isDataLakeAutoExpireSnapshot() || (Boolean)committerInitContext.lakeTieringConfig().get(ConfigOptions.LAKE_TIERING_AUTO_EXPIRE_SNAPSHOT) != false);
    }

    public PaimonCommittable toCommittable(List<PaimonWriteResult> paimonWriteResults) throws IOException {
        ManifestCommittable committable = new ManifestCommittable(Long.MAX_VALUE);
        for (PaimonWriteResult paimonWriteResult : paimonWriteResults) {
            committable.addFileCommittable(paimonWriteResult.commitMessage());
        }
        return new PaimonCommittable(committable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LakeCommitResult commit(PaimonCommittable committable, Map<String, String> snapshotProperties) throws IOException {
        ManifestCommittable manifestCommittable = committable.manifestCommittable();
        snapshotProperties.forEach((arg_0, arg_1) -> ((ManifestCommittable)manifestCommittable).addProperty(arg_0, arg_1));
        try {
            this.tableCommit = this.fileStoreTable.newCommit("__fluss_lake_tiering");
            this.tableCommit.commit(manifestCommittable);
            long committedSnapshotId = (Long)Preconditions.checkNotNull((Object)currentCommitSnapshotId.get(), (String)"Paimon committed snapshot id must be non-null.");
            currentCommitSnapshotId.remove();
            if (!this.fileStoreTable.coreOptions().deletionVectorsEnabled()) {
                return LakeCommitResult.committedIsReadable((long)committedSnapshotId);
            }
            try (DvTableReadableSnapshotRetriever retriever = new DvTableReadableSnapshotRetriever(this.tablePath, this.tableId, this.fileStoreTable, this.flussClientConfig);){
                DvTableReadableSnapshotRetriever.ReadableSnapshotResult readableSnapshotResult = retriever.getReadableSnapshotAndOffsets(committedSnapshotId);
                if (readableSnapshotResult == null) {
                    LakeCommitResult lakeCommitResult = LakeCommitResult.unknownReadableSnapshot((long)committedSnapshotId);
                    return lakeCommitResult;
                }
                long earliestSnapshotIdToKeep = readableSnapshotResult.getEarliestSnapshotIdToKeep();
                if (earliestSnapshotIdToKeep >= 0L) {
                    LOG.info("earliest snapshot ID to keep for table {} is {}. Snapshots before this ID can be safely deleted from Fluss.", (Object)this.tablePath, (Object)earliestSnapshotIdToKeep);
                }
                LakeCommitResult lakeCommitResult = LakeCommitResult.withReadableSnapshot((long)committedSnapshotId, (long)readableSnapshotResult.getReadableSnapshotId(), readableSnapshotResult.getTieredOffsets(), readableSnapshotResult.getReadableOffsets(), (Long)earliestSnapshotIdToKeep);
                return lakeCommitResult;
            }
        }
        catch (Throwable t) {
            if (this.tableCommit == null) throw new IOException(t);
            this.tableCommit.abort(manifestCommittable.fileCommittables());
            throw new IOException(t);
        }
    }

    public void abort(PaimonCommittable committable) throws IOException {
        this.tableCommit = this.fileStoreTable.newCommit("__fluss_lake_tiering");
        this.tableCommit.abort(committable.manifestCommittable().fileCommittables());
    }

    @Nullable
    public CommittedLakeSnapshot getMissingLakeSnapshot(@Nullable Long latestLakeSnapshotIdOfFluss) throws IOException {
        Snapshot latestLakeSnapshotOfLake = this.getCommittedLatestSnapshotOfLake("__fluss_lake_tiering");
        if (latestLakeSnapshotOfLake == null) {
            return null;
        }
        if (latestLakeSnapshotIdOfFluss != null && latestLakeSnapshotOfLake.id() <= latestLakeSnapshotIdOfFluss) {
            return null;
        }
        if (latestLakeSnapshotOfLake.properties() == null) {
            throw new IOException("Failed to load committed lake snapshot properties from Paimon.");
        }
        return new CommittedLakeSnapshot(latestLakeSnapshotOfLake.id(), latestLakeSnapshotOfLake.properties());
    }

    @Nullable
    private Snapshot getCommittedLatestSnapshotOfLake(String commitUser) throws IOException {
        SnapshotManager snapshotManager = this.fileStoreTable.snapshotManager();
        Long userCommittedSnapshotIdOrLatestCommitId = this.fileStoreTable.snapshotManager().pickOrLatest(snapshot -> snapshot.commitUser().equals(commitUser));
        if (userCommittedSnapshotIdOrLatestCommitId == null) {
            return null;
        }
        Snapshot snapshot2 = snapshotManager.tryGetSnapshot(userCommittedSnapshotIdOrLatestCommitId.longValue());
        if (!snapshot2.commitUser().equals(commitUser)) {
            return null;
        }
        return snapshot2;
    }

    public void close() throws Exception {
        try {
            if (this.tableCommit != null) {
                this.tableCommit.close();
            }
            if (this.paimonCatalog != null) {
                this.paimonCatalog.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to close PaimonLakeCommitter.", e);
        }
    }

    private FileStoreTable getTable(TablePath tablePath, boolean isAutoSnapshotExpiration) throws IOException {
        try {
            FileStoreTable table = (FileStoreTable)this.paimonCatalog.getTable(PaimonConversions.toPaimon(tablePath));
            HashMap<String, String> dynamicOptions = new HashMap<String, String>();
            dynamicOptions.put(CoreOptions.COMMIT_CALLBACKS.key(), PaimonCommitCallback.class.getName());
            dynamicOptions.put(CoreOptions.WRITE_ONLY.key(), isAutoSnapshotExpiration ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
            return table.copy(dynamicOptions);
        }
        catch (Exception e) {
            throw new IOException("Failed to get table " + tablePath + " in Paimon.", e);
        }
    }

    public static class PaimonCommitCallback
    implements CommitCallback {
        public void call(List<SimpleFileEntry> baseFiles, List<ManifestEntry> deltaFiles, List<IndexManifestEntry> indexFiles, Snapshot snapshot) {
            currentCommitSnapshotId.set(snapshot.id());
        }

        public void retry(ManifestCommittable manifestCommittable) {
        }

        public void close() throws Exception {
        }
    }
}

