/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.fluss.lake.paimon.tiering.FlussRecordAsPaimonRow;
import org.apache.fluss.metadata.TableBucket;
import org.apache.fluss.record.LogRecord;
import org.apache.fluss.utils.Preconditions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.RowType;

public abstract class RecordWriter<T>
implements AutoCloseable {
    protected final TableWriteImpl<T> tableWrite;
    protected final RowType tableRowType;
    protected final int bucket;
    protected final List<String> partitionKeys;
    @Nullable
    protected BinaryRow partition;
    protected final FlussRecordAsPaimonRow flussRecordAsPaimonRow;

    public RecordWriter(TableWriteImpl<T> tableWrite, RowType tableRowType, TableBucket tableBucket, @Nullable String partition, List<String> partitionKeys) {
        this.tableWrite = tableWrite;
        this.tableRowType = tableRowType;
        this.bucket = tableBucket.getBucket();
        this.partitionKeys = partitionKeys;
        if (partition == null || partitionKeys.isEmpty()) {
            this.partition = BinaryRow.EMPTY_ROW;
        }
        this.flussRecordAsPaimonRow = new FlussRecordAsPaimonRow(tableBucket.getBucket(), tableRowType);
    }

    public abstract void write(LogRecord var1) throws Exception;

    CommitMessage complete() throws Exception {
        List commitMessages = this.tableWrite.prepareCommit();
        Preconditions.checkState((commitMessages.size() == 1 ? 1 : 0) != 0, (String)"The size of CommitMessage must be 1, but got %s.", (Object[])new Object[]{commitMessages});
        return (CommitMessage)commitMessages.get(0);
    }

    @Override
    public void close() throws Exception {
        this.tableWrite.close();
    }
}

