/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering.mergetree;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.fluss.lake.paimon.tiering.RecordWriter;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.metadata.TableBucket;
import org.apache.fluss.record.LogRecord;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.RowKeyExtractor;
import org.apache.paimon.table.sink.TableWriteImpl;

public class MergeTreeWriter
extends RecordWriter<KeyValue> {
    private static final String FLUSS_TIERING_TMP_DIR_KEY = "fluss.tiering.io-tmpdir";
    private final KeyValue keyValue = new KeyValue();
    private final RowKeyExtractor rowKeyExtractor;

    public MergeTreeWriter(FileStoreTable fileStoreTable, TableBucket tableBucket, @Nullable String partition, List<String> partitionKeys) {
        super(MergeTreeWriter.createTableWrite(fileStoreTable), fileStoreTable.rowType(), tableBucket, partition, partitionKeys);
        this.rowKeyExtractor = fileStoreTable.createRowKeyExtractor();
    }

    private static TableWriteImpl<KeyValue> createTableWrite(FileStoreTable fileStoreTable) {
        Map props = fileStoreTable.options();
        String tmpDir = props.getOrDefault(FLUSS_TIERING_TMP_DIR_KEY, System.getProperty("java.io.tmpdir"));
        return fileStoreTable.newWrite("__fluss_lake_tiering").withIOManager(IOManager.create((String)tmpDir));
    }

    @Override
    public void write(LogRecord record) throws Exception {
        this.flussRecordAsPaimonRow.setFlussRecord(record);
        if (this.partition == null) {
            this.partition = this.tableWrite.getPartition((InternalRow)this.flussRecordAsPaimonRow);
        }
        this.rowKeyExtractor.setRecord((InternalRow)this.flussRecordAsPaimonRow);
        this.keyValue.replace((InternalRow)this.rowKeyExtractor.trimmedPrimaryKey(), -1L, PaimonConversions.toRowKind(record.getChangeType()), (InternalRow)this.flussRecordAsPaimonRow);
        this.tableWrite.getWrite().write(this.partition, this.bucket, (Object)this.keyValue);
    }
}

