/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import org.apache.fluss.types.ArrayType;
import org.apache.fluss.types.BigIntType;
import org.apache.fluss.types.BinaryType;
import org.apache.fluss.types.BooleanType;
import org.apache.fluss.types.BytesType;
import org.apache.fluss.types.CharType;
import org.apache.fluss.types.DataField;
import org.apache.fluss.types.DataTypeVisitor;
import org.apache.fluss.types.DateType;
import org.apache.fluss.types.DecimalType;
import org.apache.fluss.types.DoubleType;
import org.apache.fluss.types.FloatType;
import org.apache.fluss.types.IntType;
import org.apache.fluss.types.LocalZonedTimestampType;
import org.apache.fluss.types.MapType;
import org.apache.fluss.types.RowType;
import org.apache.fluss.types.SmallIntType;
import org.apache.fluss.types.StringType;
import org.apache.fluss.types.TimeType;
import org.apache.fluss.types.TimestampType;
import org.apache.fluss.types.TinyIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class FlussDataTypeToPaimonDataType
implements DataTypeVisitor<DataType> {
    public static final FlussDataTypeToPaimonDataType INSTANCE = new FlussDataTypeToPaimonDataType();

    public DataType visit(CharType charType) {
        return this.withNullability((DataType)DataTypes.CHAR((int)charType.getLength()), charType.isNullable());
    }

    public DataType visit(StringType stringType) {
        return this.withNullability((DataType)DataTypes.STRING(), stringType.isNullable());
    }

    public DataType visit(BooleanType booleanType) {
        return this.withNullability((DataType)DataTypes.BOOLEAN(), booleanType.isNullable());
    }

    public DataType visit(BinaryType binaryType) {
        return this.withNullability((DataType)DataTypes.BINARY((int)binaryType.getLength()), binaryType.isNullable());
    }

    public DataType visit(BytesType bytesType) {
        return this.withNullability((DataType)DataTypes.BYTES(), bytesType.isNullable());
    }

    public DataType visit(DecimalType decimalType) {
        return this.withNullability((DataType)DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale()), decimalType.isNullable());
    }

    public DataType visit(TinyIntType tinyIntType) {
        return this.withNullability((DataType)DataTypes.TINYINT(), tinyIntType.isNullable());
    }

    public DataType visit(SmallIntType smallIntType) {
        return this.withNullability((DataType)DataTypes.SMALLINT(), smallIntType.isNullable());
    }

    public DataType visit(IntType intType) {
        return this.withNullability((DataType)DataTypes.INT(), intType.isNullable());
    }

    public DataType visit(BigIntType bigIntType) {
        return this.withNullability((DataType)DataTypes.BIGINT(), bigIntType.isNullable());
    }

    public DataType visit(FloatType floatType) {
        return this.withNullability((DataType)DataTypes.FLOAT(), floatType.isNullable());
    }

    public DataType visit(DoubleType doubleType) {
        return this.withNullability((DataType)DataTypes.DOUBLE(), doubleType.isNullable());
    }

    public DataType visit(DateType dateType) {
        return this.withNullability((DataType)DataTypes.DATE(), dateType.isNullable());
    }

    public DataType visit(TimeType timeType) {
        return this.withNullability((DataType)DataTypes.TIME(), timeType.isNullable());
    }

    public DataType visit(TimestampType timestampType) {
        return this.withNullability((DataType)DataTypes.TIMESTAMP((int)timestampType.getPrecision()), timestampType.isNullable());
    }

    public DataType visit(LocalZonedTimestampType localZonedTimestampType) {
        return this.withNullability((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)localZonedTimestampType.getPrecision()), localZonedTimestampType.isNullable());
    }

    public DataType visit(ArrayType arrayType) {
        return this.withNullability((DataType)DataTypes.ARRAY((DataType)((DataType)arrayType.getElementType().accept((DataTypeVisitor)this))), arrayType.isNullable());
    }

    public DataType visit(MapType mapType) {
        return this.withNullability((DataType)DataTypes.MAP((DataType)((DataType)mapType.getKeyType().accept((DataTypeVisitor)this)), (DataType)((DataType)mapType.getValueType().accept((DataTypeVisitor)this))), mapType.isNullable());
    }

    public DataType visit(RowType rowType) {
        RowType.Builder rowTypeBuilder = org.apache.paimon.types.RowType.builder();
        for (DataField field : rowType.getFields()) {
            rowTypeBuilder.field(field.getName(), (DataType)field.getType().accept((DataTypeVisitor)this), (String)field.getDescription().orElse(null));
        }
        return this.withNullability((DataType)rowTypeBuilder.build(), rowType.isNullable());
    }

    private DataType withNullability(DataType paimon, boolean nullable) {
        if (paimon.isNullable() != nullable) {
            return nullable ? paimon.nullable() : paimon.notNull();
        }
        return paimon;
    }
}

