/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.math.BigDecimal;
import org.apache.fluss.lake.paimon.PaimonLakeCatalog;
import org.apache.fluss.lake.paimon.utils.PaimonArrayAsFlussArray;
import org.apache.fluss.lake.paimon.utils.PaimonMapAsFlussMap;
import org.apache.fluss.row.BinaryString;
import org.apache.fluss.row.Decimal;
import org.apache.fluss.row.InternalArray;
import org.apache.fluss.row.InternalMap;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.row.TimestampLtz;
import org.apache.fluss.row.TimestampNtz;
import org.apache.paimon.data.Timestamp;

public class PaimonRowAsFlussRow
implements InternalRow {
    private org.apache.paimon.data.InternalRow paimonRow;

    public PaimonRowAsFlussRow() {
    }

    public PaimonRowAsFlussRow(org.apache.paimon.data.InternalRow paimonRow) {
        this.paimonRow = paimonRow;
    }

    public PaimonRowAsFlussRow replaceRow(org.apache.paimon.data.InternalRow paimonRow) {
        this.paimonRow = paimonRow;
        return this;
    }

    public int getFieldCount() {
        return this.paimonRow.getFieldCount() - PaimonLakeCatalog.SYSTEM_COLUMNS.size();
    }

    public boolean isNullAt(int pos) {
        return this.paimonRow.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.paimonRow.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.paimonRow.getByte(pos);
    }

    public short getShort(int pos) {
        return this.paimonRow.getShort(pos);
    }

    public int getInt(int pos) {
        return this.paimonRow.getInt(pos);
    }

    public long getLong(int pos) {
        return this.paimonRow.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.paimonRow.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.paimonRow.getDouble(pos);
    }

    public BinaryString getChar(int pos, int length) {
        return BinaryString.fromBytes((byte[])this.paimonRow.getString(pos).toBytes());
    }

    public BinaryString getString(int pos) {
        return BinaryString.fromBytes((byte[])this.paimonRow.getString(pos).toBytes());
    }

    public Decimal getDecimal(int pos, int precision, int scale) {
        org.apache.paimon.data.Decimal paimonDecimal = this.paimonRow.getDecimal(pos, precision, scale);
        if (paimonDecimal.isCompact()) {
            return Decimal.fromUnscaledLong((long)paimonDecimal.toUnscaledLong(), (int)precision, (int)scale);
        }
        return Decimal.fromBigDecimal((BigDecimal)paimonDecimal.toBigDecimal(), (int)precision, (int)scale);
    }

    public TimestampNtz getTimestampNtz(int pos, int precision) {
        Timestamp timestamp = this.paimonRow.getTimestamp(pos, precision);
        if (TimestampNtz.isCompact((int)precision)) {
            return TimestampNtz.fromMillis((long)timestamp.getMillisecond());
        }
        return TimestampNtz.fromMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public TimestampLtz getTimestampLtz(int pos, int precision) {
        Timestamp timestamp = this.paimonRow.getTimestamp(pos, precision);
        if (TimestampLtz.isCompact((int)precision)) {
            return TimestampLtz.fromEpochMillis((long)timestamp.getMillisecond());
        }
        return TimestampLtz.fromEpochMillis((long)timestamp.getMillisecond(), (int)timestamp.getNanoOfMillisecond());
    }

    public byte[] getBinary(int pos, int length) {
        return this.paimonRow.getBinary(pos);
    }

    public byte[] getBytes(int pos) {
        return this.paimonRow.getBinary(pos);
    }

    public InternalArray getArray(int pos) {
        return new PaimonArrayAsFlussArray(this.paimonRow.getArray(pos));
    }

    public InternalMap getMap(int pos) {
        return new PaimonMapAsFlussMap(this.paimonRow.getMap(pos));
    }

    public InternalRow getRow(int pos, int numFields) {
        return new PaimonRowAsFlussRow(this.paimonRow.getRow(pos, numFields));
    }
}

