/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.fluss.config.ConfigOptions;
import org.apache.fluss.exception.TableAlreadyExistException;
import org.apache.fluss.metadata.TablePath;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class PaimonTableValidation {
    private static final Map<String, ConfigOption<?>> PAIMON_CONFIGS = PaimonTableValidation.extractPaimonConfigs();

    public static boolean isPaimonSchemaCompatible(Schema existingSchema, Schema newSchema) {
        Map existingOptions = existingSchema.options();
        Map newOptions = newSchema.options();
        String datalakeConfigKey = "fluss." + ConfigOptions.TABLE_DATALAKE_ENABLED.key();
        if (Boolean.FALSE.toString().equalsIgnoreCase((String)existingOptions.get(datalakeConfigKey))) {
            existingOptions.remove(datalakeConfigKey);
            newOptions.remove(datalakeConfigKey);
        }
        PaimonTableValidation.removeChangeableOptions(existingOptions);
        PaimonTableValidation.removeChangeableOptions(newOptions);
        existingOptions.entrySet().removeIf(entry -> !newOptions.containsKey(entry.getKey()));
        if (!PaimonTableValidation.equalIgnoreFieldId(existingSchema, newSchema)) {
            return PaimonTableValidation.equalIgnoreSystemColumnTimestampPrecision(existingSchema, newSchema);
        }
        return true;
    }

    public static boolean equalIgnoreSystemColumnTimestampPrecision(Schema existingSchema, Schema newSchema) {
        ArrayList<DataField> existingFields = new ArrayList<DataField>(existingSchema.fields());
        DataField systemTimestampField = (DataField)existingFields.get(existingFields.size() - 1);
        if (systemTimestampField.name().equals("__timestamp") && systemTimestampField.type().equalsIgnoreFieldId((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE())) {
            existingFields.set(existingFields.size() - 1, new DataField(systemTimestampField.id(), systemTimestampField.name(), (DataType)DataTypes.TIMESTAMP_LTZ_MILLIS(), systemTimestampField.description()));
        }
        existingSchema = existingSchema.copy(RowType.of((DataField[])existingFields.toArray(new DataField[0])));
        return PaimonTableValidation.equalIgnoreFieldId(existingSchema, newSchema);
    }

    private static boolean equalIgnoreFieldId(Schema existingSchema, Schema newSchema) {
        List existingFields = existingSchema.fields();
        List newFields = newSchema.fields();
        for (int i = 0; i < existingFields.size(); ++i) {
            DataField newField;
            DataField existingField = (DataField)existingFields.get(i);
            if (existingField.equalsIgnoreFieldId(newField = (DataField)newFields.get(i))) continue;
            return false;
        }
        return Objects.equals(existingSchema.partitionKeys(), newSchema.partitionKeys()) && Objects.equals(existingSchema.primaryKeys(), newSchema.primaryKeys()) && Objects.equals(existingSchema.options(), newSchema.options()) && Objects.equals(existingSchema.comment(), newSchema.comment());
    }

    private static void removeChangeableOptions(Map<String, String> options) {
        options.entrySet().removeIf(entry -> !PAIMON_CONFIGS.containsKey(entry.getKey()) && !((String)entry.getKey()).startsWith("fluss."));
    }

    public static void checkTableIsEmpty(TablePath tablePath, FileStoreTable table) {
        if (table.latestSnapshot().isPresent()) {
            throw new TableAlreadyExistException(String.format("The table %s already exists in Paimon catalog, and the table is not empty. Please first drop the table in Paimon catalog or use a new table name.", tablePath));
        }
    }

    private static Map<String, ConfigOption<?>> extractPaimonConfigs() {
        Field[] fields;
        HashMap options = new HashMap();
        for (Field field : fields = CoreOptions.class.getFields()) {
            if (!ConfigOption.class.isAssignableFrom(field.getType())) continue;
            try {
                ConfigOption configOption = (ConfigOption)field.get(null);
                options.put(configOption.key(), configOption);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to extract ConfigOption fields from CoreOptions class.", e);
            }
        }
        return options;
    }
}

