/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.index;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.utils.ObjectSerializer;

public class IndexFileMetaSerializer
extends ObjectSerializer<IndexFileMeta> {
    public IndexFileMetaSerializer() {
        super(IndexFileMeta.SCHEMA);
    }

    @Override
    public InternalRow toRow(IndexFileMeta record) {
        return GenericRow.of(BinaryString.fromString(record.indexType()), BinaryString.fromString(record.fileName()), record.fileSize(), record.rowCount(), IndexFileMetaSerializer.dvMetasToRowArrayData(record.dvRanges()), BinaryString.fromString(record.externalPath()));
    }

    @Override
    public IndexFileMeta fromRow(InternalRow row) {
        return new IndexFileMeta(row.getString(0).toString(), row.getString(1).toString(), row.getLong(2), row.getLong(3), row.isNullAt(4) ? null : IndexFileMetaSerializer.rowArrayDataToDvMetas(row.getArray(4)), row.isNullAt(5) ? null : row.getString(5).toString());
    }

    public static InternalArray dvMetasToRowArrayData(LinkedHashMap<String, DeletionVectorMeta> dvRanges) {
        if (dvRanges == null) {
            return null;
        }
        return IndexFileMetaSerializer.dvMetasToRowArrayData(dvRanges.values());
    }

    public static InternalArray dvMetasToRowArrayData(Collection<DeletionVectorMeta> dvMetas) {
        return new GenericArray(dvMetas.stream().map(dvMeta -> GenericRow.of(BinaryString.fromString(dvMeta.dataFileName()), dvMeta.offset(), dvMeta.length(), dvMeta.cardinality())).toArray(GenericRow[]::new));
    }

    public static LinkedHashMap<String, DeletionVectorMeta> rowArrayDataToDvMetas(InternalArray arrayData) {
        LinkedHashMap<String, DeletionVectorMeta> dvMetas = new LinkedHashMap<String, DeletionVectorMeta>(arrayData.size());
        for (int i = 0; i < arrayData.size(); ++i) {
            InternalRow row = arrayData.getRow(i, DeletionVectorMeta.SCHEMA.getFieldCount());
            String dataFileName = row.getString(0).toString();
            dvMetas.put(dataFileName, new DeletionVectorMeta(dataFileName, row.getInt(1), row.getInt(2), row.isNullAt(3) ? null : Long.valueOf(row.getLong(3))));
        }
        return dvMetas;
    }
}

