/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.SimpleFileEntry;

public class ExpireFileEntry
extends SimpleFileEntry {
    @Nullable
    private final FileSource fileSource;

    public ExpireFileEntry(FileKind kind, BinaryRow partition, int bucket, int totalBuckets, int level, String fileName, List<String> extraFiles, @Nullable byte[] embeddedIndex, BinaryRow minKey, BinaryRow maxKey, @Nullable FileSource fileSource, @Nullable String externalPath) {
        super(kind, partition, bucket, totalBuckets, level, fileName, extraFiles, embeddedIndex, minKey, maxKey, externalPath);
        this.fileSource = fileSource;
    }

    public Optional<FileSource> fileSource() {
        return Optional.ofNullable(this.fileSource);
    }

    public static ExpireFileEntry from(ManifestEntry entry) {
        return new ExpireFileEntry(entry.kind(), entry.partition(), entry.bucket(), entry.totalBuckets(), entry.level(), entry.fileName(), entry.file().extraFiles(), entry.file().embeddedIndex(), entry.minKey(), entry.maxKey(), entry.file().fileSource().orElse(null), entry.externalPath());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExpireFileEntry that = (ExpireFileEntry)o;
        return this.fileSource == that.fileSource;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fileSource});
    }
}

