/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FilteredManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.BucketSelectConverter;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final SimpleStatsEvolutions fieldKeyStatsConverters;
    private final SimpleStatsEvolutions fieldValueStatsConverters;
    private final BucketSelectConverter bucketSelectConverter;
    private final boolean deletionVectorsEnabled;
    private final CoreOptions.MergeEngine mergeEngine;
    private final CoreOptions.ChangelogProducer changelogProducer;
    private final boolean fileIndexReadEnabled;
    private Predicate keyFilter;
    private Predicate valueFilter;
    private boolean valueFilterForceEnabled = false;
    private final Map<Long, Predicate> notEvolvedKeyFilterMapping = new ConcurrentHashMap<Long, Predicate>();
    private final Map<Long, Predicate> notEvolvedValueFilterMapping = new ConcurrentHashMap<Long, Predicate>();
    private final Map<Long, Predicate> evolvedValueFilterMapping = new ConcurrentHashMap<Long, Predicate>();

    public KeyValueFileStoreScan(ManifestsReader manifestsReader, BucketSelectConverter bucketSelectConverter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, Integer scanManifestParallelism, boolean deletionVectorsEnabled, CoreOptions.MergeEngine mergeEngine, CoreOptions.ChangelogProducer changelogProducer, boolean fileIndexReadEnabled) {
        super(manifestsReader, snapshotManager, schemaManager, schema, manifestFileFactory, scanManifestParallelism);
        this.bucketSelectConverter = bucketSelectConverter;
        this.fieldKeyStatsConverters = new SimpleStatsEvolutions(sid -> this.scanTableSchema((long)sid).trimmedPrimaryKeysFields(), schema.id());
        this.fieldValueStatsConverters = new SimpleStatsEvolutions(sid -> keyValueFieldsExtractor.valueFields(this.scanTableSchema((long)sid)), schema.id());
        this.deletionVectorsEnabled = deletionVectorsEnabled;
        this.mergeEngine = mergeEngine;
        this.changelogProducer = changelogProducer;
        this.fileIndexReadEnabled = fileIndexReadEnabled;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        this.bucketSelectConverter.convert(predicate).ifPresent(this::withTotalAwareBucketFilter);
        return this;
    }

    public KeyValueFileStoreScan withValueFilter(Predicate predicate) {
        this.valueFilter = predicate;
        return this;
    }

    @Override
    public FileStoreScan enableValueFilter() {
        this.valueFilterForceEnabled = true;
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        if (this.isValueFilterEnabled() && !this.filterByValueFilter(entry)) {
            return false;
        }
        Predicate notEvolvedFilter = this.notEvolvedKeyFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.fieldKeyStatsConverters.filterUnsafeFilter(entry.file().schemaId(), this.keyFilter, true));
        if (notEvolvedFilter == null) {
            return true;
        }
        DataFileMeta file = entry.file();
        SimpleStatsEvolution.Result stats = this.fieldKeyStatsConverters.getOrCreate(file.schemaId()).evolution(file.keyStats(), (Long)file.rowCount(), null);
        return notEvolvedFilter.test(file.rowCount(), stats.minValues(), stats.maxValues(), stats.nullCounts());
    }

    @Override
    protected ManifestEntry dropStats(ManifestEntry entry) {
        if (!this.isValueFilterEnabled() && this.wholeBucketFilterEnabled()) {
            return new FilteredManifestEntry(entry.copyWithoutStats(), this.filterByValueFilter(entry));
        }
        return entry.copyWithoutStats();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean filterByFileIndex(@Nullable byte[] embeddedIndexBytes, ManifestEntry entry) {
        if (embeddedIndexBytes == null) {
            return true;
        }
        RowType dataRowType = this.scanTableSchema(entry.file().schemaId()).logicalRowType();
        try (FileIndexPredicate predicate = new FileIndexPredicate(embeddedIndexBytes, dataRowType);){
            Predicate dataPredicate = this.evolvedValueFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.fieldValueStatsConverters.tryDevolveFilter(entry.file().schemaId(), this.valueFilter));
            boolean bl = predicate.evaluate(dataPredicate).remain();
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception happens while checking fileIndex predicate.", e);
        }
    }

    private boolean isValueFilterEnabled() {
        if (this.valueFilter == null) {
            return false;
        }
        switch (this.scanMode) {
            case ALL: {
                return this.valueFilterForceEnabled;
            }
            case DELTA: {
                return false;
            }
            case CHANGELOG: {
                return this.changelogProducer == CoreOptions.ChangelogProducer.LOOKUP || this.changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION;
            }
        }
        throw new UnsupportedOperationException("Unsupported scan mode: " + (Object)((Object)this.scanMode));
    }

    @Override
    protected boolean wholeBucketFilterEnabled() {
        return this.valueFilter != null && this.scanMode == ScanMode.ALL;
    }

    @Override
    protected List<ManifestEntry> filterWholeBucketByStats(List<ManifestEntry> entries) {
        return KeyValueFileStoreScan.noOverlapping(entries) ? this.filterWholeBucketPerFile(entries) : this.filterWholeBucketAllFiles(entries);
    }

    private List<ManifestEntry> filterWholeBucketPerFile(List<ManifestEntry> entries) {
        ArrayList<ManifestEntry> filtered = new ArrayList<ManifestEntry>();
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private List<ManifestEntry> filterWholeBucketAllFiles(List<ManifestEntry> entries) {
        if (!(this.deletionVectorsEnabled || this.mergeEngine != CoreOptions.MergeEngine.PARTIAL_UPDATE && this.mergeEngine != CoreOptions.MergeEngine.AGGREGATE)) {
            return entries;
        }
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            return entries;
        }
        return Collections.emptyList();
    }

    private boolean filterByValueFilter(ManifestEntry entry) {
        if (entry instanceof FilteredManifestEntry) {
            return ((FilteredManifestEntry)entry).selected();
        }
        Predicate notEvolvedFilter = this.notEvolvedValueFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.fieldValueStatsConverters.filterUnsafeFilter(entry.file().schemaId(), this.valueFilter, true));
        if (notEvolvedFilter == null) {
            return true;
        }
        DataFileMeta file = entry.file();
        SimpleStatsEvolution.Result result = this.fieldValueStatsConverters.getOrCreate(file.schemaId()).evolution(file.valueStats(), (Long)file.rowCount(), file.valueStatsCols());
        return notEvolvedFilter.test(file.rowCount(), result.minValues(), result.maxValues(), result.nullCounts()) && (!this.fileIndexReadEnabled || this.filterByFileIndex(entry.file().embeddedIndex(), entry));
    }

    private static boolean noOverlapping(List<ManifestEntry> entries) {
        if (entries.size() <= 1) {
            return true;
        }
        Integer previousLevel = null;
        for (ManifestEntry entry : entries) {
            int level = entry.file().level();
            if (level == 0) {
                return false;
            }
            if (previousLevel == null) {
                previousLevel = level;
                continue;
            }
            if (previousLevel == level) continue;
            return false;
        }
        return true;
    }
}

