/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.responses;

import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.function.FunctionImpl;
import org.apache.paimon.rest.responses.AuditRESTResponse;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataField;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GetFunctionResponse
extends AuditRESTResponse {
    private static final String FIELD_UUID = "uuid";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_INPUT_PARAMETERS = "inputParams";
    private static final String FIELD_RETURN_PARAMETERS = "returnParams";
    private static final String FIELD_DEFINITIONS = "definitions";
    private static final String FIELD_DETERMINISTIC = "deterministic";
    private static final String FIELD_COMMENT = "comment";
    private static final String FIELD_OPTIONS = "options";
    @JsonProperty(value="uuid")
    private final String uuid;
    @JsonProperty(value="name")
    private final String functionName;
    @JsonProperty(value="inputParams")
    private final List<DataField> inputParams;
    @JsonProperty(value="returnParams")
    private final List<DataField> returnParams;
    @JsonProperty(value="deterministic")
    private final boolean deterministic;
    @JsonProperty(value="definitions")
    private final Map<String, FunctionDefinition> definitions;
    @JsonProperty(value="comment")
    private final String comment;
    @JsonProperty(value="options")
    private final Map<String, String> options;

    @JsonCreator
    public GetFunctionResponse(@JsonProperty(value="uuid") String uuid, @JsonProperty(value="name") String functionName, @JsonProperty(value="inputParams") List<DataField> inputParams, @JsonProperty(value="returnParams") List<DataField> returnParams, @JsonProperty(value="deterministic") boolean deterministic, @JsonProperty(value="definitions") Map<String, FunctionDefinition> definitions, @JsonProperty(value="comment") String comment, @JsonProperty(value="options") Map<String, String> options, @JsonProperty(value="owner") String owner, @JsonProperty(value="createdAt") long createdAt, @JsonProperty(value="createdBy") String createdBy, @JsonProperty(value="updatedAt") long updatedAt, @JsonProperty(value="updatedBy") String updatedBy) {
        super(owner, createdAt, createdBy, updatedAt, updatedBy);
        this.functionName = functionName;
        this.uuid = uuid;
        this.inputParams = inputParams;
        this.returnParams = returnParams;
        this.deterministic = deterministic;
        this.definitions = definitions;
        this.comment = comment;
        this.options = options;
    }

    public String uuid() {
        return this.uuid;
    }

    public String name() {
        return this.functionName;
    }

    @JsonGetter(value="inputParams")
    public List<DataField> inputParams() {
        return this.inputParams;
    }

    @JsonGetter(value="returnParams")
    public List<DataField> returnParams() {
        return this.returnParams;
    }

    @JsonGetter(value="deterministic")
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @JsonGetter(value="definitions")
    public Map<String, FunctionDefinition> definitions() {
        return this.definitions;
    }

    public FunctionDefinition definition(String dialect) {
        return this.definitions.get(dialect);
    }

    @JsonGetter(value="comment")
    public String comment() {
        return this.comment;
    }

    @JsonGetter(value="options")
    public Map<String, String> options() {
        return this.options;
    }

    public Function toFunction(Identifier identifier) {
        return new FunctionImpl(identifier, this.inputParams, this.returnParams, this.deterministic, this.definitions, this.comment, this.options);
    }
}

