/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.format;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateProjectionConverter;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.format.FormatDataSplit;
import org.apache.paimon.table.format.FormatReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.RowType;

public class FormatTableRead
implements TableRead {
    private final RowType readType;
    private final Predicate predicate;
    private final FormatReadBuilder read;
    private final Integer limit;
    private boolean executeFilter = false;

    public FormatTableRead(RowType readType, FormatReadBuilder read, Predicate predicate, Integer limit) {
        this.readType = readType;
        this.read = read;
        this.predicate = predicate;
        this.limit = limit;
    }

    @Override
    public TableRead withMetricRegistry(MetricRegistry registry) {
        return this;
    }

    @Override
    public TableRead executeFilter() {
        this.executeFilter = true;
        return this;
    }

    @Override
    public TableRead withIOManager(IOManager ioManager) {
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(Split split) throws IOException {
        FormatDataSplit dataSplit = (FormatDataSplit)split;
        RecordReader<InternalRow> reader = this.read.createReader(dataSplit);
        if (this.executeFilter) {
            reader = this.executeFilter(reader);
        }
        if (this.limit != null && this.limit > 0) {
            reader = this.applyLimit(reader, this.limit);
        }
        return reader;
    }

    private RecordReader<InternalRow> executeFilter(RecordReader<InternalRow> reader) {
        if (this.predicate == null) {
            return reader;
        }
        Predicate predicate = this.predicate;
        if (this.readType != null) {
            int[] projection = this.readType.getFieldIndices(this.readType.getFieldNames());
            Optional<Predicate> optional = predicate.visit(new PredicateProjectionConverter(projection));
            if (!optional.isPresent()) {
                return reader;
            }
            predicate = optional.get();
        }
        Predicate finalFilter = predicate;
        return reader.filter(finalFilter::test);
    }

    private RecordReader<InternalRow> applyLimit(final RecordReader<InternalRow> reader, final int limit) {
        return new RecordReader<InternalRow>(){
            private final AtomicLong recordCount = new AtomicLong(0L);

            @Override
            public RecordReader.RecordIterator<InternalRow> readBatch() throws IOException {
                if (this.recordCount.get() >= (long)limit) {
                    return null;
                }
                final RecordReader.RecordIterator iterator = reader.readBatch();
                if (iterator == null) {
                    return null;
                }
                return new RecordReader.RecordIterator<InternalRow>(){

                    @Override
                    public InternalRow next() throws IOException {
                        if (recordCount.get() >= (long)limit) {
                            return null;
                        }
                        InternalRow next = (InternalRow)iterator.next();
                        if (next != null) {
                            recordCount.incrementAndGet();
                        }
                        return next;
                    }

                    @Override
                    public void releaseBatch() {
                        iterator.releaseBatch();
                    }
                };
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }
}

