/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.MultiSegments;
import org.apache.paimon.data.RandomAccessInputView;
import org.apache.paimon.data.Segments;
import org.apache.paimon.data.SimpleCollectingOutputView;
import org.apache.paimon.data.SingleSegments;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentSource;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BiFunctionWithIOE;
import org.apache.paimon.utils.CloseableIterator;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.ObjectSerializer;
import org.apache.paimon.utils.ObjectsCache;
import org.apache.paimon.utils.SegmentsCache;

@ThreadSafe
public class SimpleObjectsCache<K, V>
extends ObjectsCache<K, V, Segments> {
    public SimpleObjectsCache(SegmentsCache<K> cache, ObjectSerializer<V> projectedSerializer, RowType formatSchema, FunctionWithIOException<K, Long> fileSizeFunction, BiFunctionWithIOE<K, Long, CloseableIterator<InternalRow>> reader) {
        super(cache, projectedSerializer, formatSchema, fileSizeFunction, reader);
    }

    public List<V> read(K key, @Nullable Long fileSize, Filter<InternalRow> readFilter, Filter<V> readVFilter) throws IOException {
        return this.read(key, fileSize, new ObjectsCache.Filters<V>(readFilter, readVFilter));
    }

    @Override
    protected List<V> readFromSegments(Segments segments, ObjectsCache.Filters<V> filters) throws IOException {
        return SimpleObjectsCache.readFromSegments((InternalRowSerializer)this.formatSerializer.get(), this.projectedSerializer, segments, filters);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Segments createSegments(K key, @Nullable Long fileSize) {
        InternalRowSerializer formatSerializer = (InternalRowSerializer)this.formatSerializer.get();
        try (CloseableIterator iterator = (CloseableIterator)this.reader.apply(key, fileSize);){
            ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>();
            MemorySegmentSource segmentSource = () -> MemorySegment.allocateHeapMemory(this.cache.pageSize());
            SimpleCollectingOutputView output = new SimpleCollectingOutputView(segments, segmentSource, this.cache.pageSize());
            while (iterator.hasNext()) {
                InternalRow row = (InternalRow)iterator.next();
                formatSerializer.serializeToPages(row, (AbstractPagedOutputView)output);
            }
            Segments segments2 = Segments.create(segments, output.getCurrentPositionInSegment());
            return segments2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> List<V> readFromSegments(InternalRowSerializer formatSerializer, ObjectSerializer<V> projectedSerializer, Segments segments, ObjectsCache.Filters<V> filters) throws IOException {
        ArrayList<V> entries = new ArrayList<V>();
        RandomAccessInputView view = SimpleObjectsCache.createInputView(segments);
        BinaryRow binaryRow = new BinaryRow(formatSerializer.getArity());
        Filter<InternalRow> readFilter = filters.readFilter();
        Filter<V> readVFilter = filters.readVFilter();
        try {
            while (true) {
                V v;
                formatSerializer.mapFromPages(binaryRow, (AbstractPagedInputView)view);
                if (!readFilter.test(binaryRow) || !readVFilter.test(v = projectedSerializer.fromRow(binaryRow))) continue;
                entries.add(v);
            }
        }
        catch (EOFException e) {
            return entries;
        }
    }

    private static RandomAccessInputView createInputView(Segments segments) {
        if (segments instanceof MultiSegments) {
            MultiSegments memorySegments = (MultiSegments)segments;
            return new RandomAccessInputView(memorySegments.segments(), memorySegments.pageSize(), memorySegments.limitInLastSegment());
        }
        if (segments instanceof SingleSegments) {
            SingleSegments singleSegments = (SingleSegments)segments;
            ArrayList<MemorySegment> array = new ArrayList<MemorySegment>();
            array.add(singleSegments.segment());
            return new RandomAccessInputView(array, singleSegments.segment().size(), singleSegments.limit());
        }
        throw new IllegalArgumentException("Unsupported segment type: " + segments.getClass());
    }
}

