/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.flink.adapter;

import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;

import javax.annotation.Nullable;

import java.util.List;
import java.util.Map;

/**
 * A adapter for {@link CatalogTable} constructor, and adapter MATERIALIZED_TABLE for {@link
 * CatalogBaseTable.TableKind} TODO: remove this class when no longer support flink 1.18 and 1.19.
 */
public class CatalogTableAdapter {
    public static CatalogTable toCatalogTable(
            Schema schema,
            @Nullable String comment,
            List<String> partitionKeys,
            Map<String, String> options) {
        return CatalogTable.newBuilder()
                .schema(schema)
                .comment(comment)
                .partitionKeys(partitionKeys)
                .options(options)
                .build();
    }

    public static boolean isMaterializedTable(CatalogBaseTable.TableKind tableKind) {
        return CatalogBaseTable.TableKind.MATERIALIZED_TABLE == tableKind;
    }
}
