/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements. See the NOTICE file distributed with this
work for additional information regarding copyright ownership. The ASF
licenses this file to You under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
License for the specific language governing permissions and limitations
under the License.
*/
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             v3.21.1
// source: worker.proto

package __

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// WorkerClient is the client API for Worker service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type WorkerClient interface {
	SayHelloPeer(ctx context.Context, in *HelloPeerReq, opts ...grpc.CallOption) (*HelloPeerResp, error)
	Scatter(ctx context.Context, opts ...grpc.CallOption) (Worker_ScatterClient, error)
	LoadAction(ctx context.Context, opts ...grpc.CallOption) (Worker_LoadActionClient, error)
	GetEdges(ctx context.Context, in *GetEdgesReq, opts ...grpc.CallOption) (*GetEdgesResp, error)
	GetVertex(ctx context.Context, in *GetVertexReq, opts ...grpc.CallOption) (*GetVertexResp, error)
	DeleteGraph(ctx context.Context, in *DeleteGraphReq, opts ...grpc.CallOption) (*DeleteGraphResp, error)
	StepEnd(ctx context.Context, opts ...grpc.CallOption) (Worker_StepEndClient, error)
	ControlTask(ctx context.Context, in *ControlTaskReq, opts ...grpc.CallOption) (*ControlTaskResp, error)
	SaveGraph(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error)
	WriteDisk(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error)
	ReadGraph(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error)
	GetWorkerStatInfo(ctx context.Context, in *WorkerStatInfoReq, opts ...grpc.CallOption) (*WorkerStatInfoResp, error)
	SettingAction(ctx context.Context, opts ...grpc.CallOption) (Worker_SettingActionClient, error)
	RuntimeAction(ctx context.Context, in *RuntimeActionReq, opts ...grpc.CallOption) (*RuntimeActionResp, error)
}

type workerClient struct {
	cc grpc.ClientConnInterface
}

func NewWorkerClient(cc grpc.ClientConnInterface) WorkerClient {
	return &workerClient{cc}
}

func (c *workerClient) SayHelloPeer(ctx context.Context, in *HelloPeerReq, opts ...grpc.CallOption) (*HelloPeerResp, error) {
	out := new(HelloPeerResp)
	err := c.cc.Invoke(ctx, "/master.Worker/SayHelloPeer", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) Scatter(ctx context.Context, opts ...grpc.CallOption) (Worker_ScatterClient, error) {
	stream, err := c.cc.NewStream(ctx, &Worker_ServiceDesc.Streams[0], "/master.Worker/Scatter", opts...)
	if err != nil {
		return nil, err
	}
	x := &workerScatterClient{stream}
	return x, nil
}

type Worker_ScatterClient interface {
	Send(*ScatterReq) error
	Recv() (*ScatterResp, error)
	grpc.ClientStream
}

type workerScatterClient struct {
	grpc.ClientStream
}

func (x *workerScatterClient) Send(m *ScatterReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *workerScatterClient) Recv() (*ScatterResp, error) {
	m := new(ScatterResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *workerClient) LoadAction(ctx context.Context, opts ...grpc.CallOption) (Worker_LoadActionClient, error) {
	stream, err := c.cc.NewStream(ctx, &Worker_ServiceDesc.Streams[1], "/master.Worker/LoadAction", opts...)
	if err != nil {
		return nil, err
	}
	x := &workerLoadActionClient{stream}
	return x, nil
}

type Worker_LoadActionClient interface {
	Send(*LoadActionReq) error
	Recv() (*LoadActionResp, error)
	grpc.ClientStream
}

type workerLoadActionClient struct {
	grpc.ClientStream
}

func (x *workerLoadActionClient) Send(m *LoadActionReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *workerLoadActionClient) Recv() (*LoadActionResp, error) {
	m := new(LoadActionResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *workerClient) GetEdges(ctx context.Context, in *GetEdgesReq, opts ...grpc.CallOption) (*GetEdgesResp, error) {
	out := new(GetEdgesResp)
	err := c.cc.Invoke(ctx, "/master.Worker/GetEdges", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) GetVertex(ctx context.Context, in *GetVertexReq, opts ...grpc.CallOption) (*GetVertexResp, error) {
	out := new(GetVertexResp)
	err := c.cc.Invoke(ctx, "/master.Worker/GetVertex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) DeleteGraph(ctx context.Context, in *DeleteGraphReq, opts ...grpc.CallOption) (*DeleteGraphResp, error) {
	out := new(DeleteGraphResp)
	err := c.cc.Invoke(ctx, "/master.Worker/DeleteGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) StepEnd(ctx context.Context, opts ...grpc.CallOption) (Worker_StepEndClient, error) {
	stream, err := c.cc.NewStream(ctx, &Worker_ServiceDesc.Streams[2], "/master.Worker/StepEnd", opts...)
	if err != nil {
		return nil, err
	}
	x := &workerStepEndClient{stream}
	return x, nil
}

type Worker_StepEndClient interface {
	Send(*StepEndReq) error
	Recv() (*StepEndResp, error)
	grpc.ClientStream
}

type workerStepEndClient struct {
	grpc.ClientStream
}

func (x *workerStepEndClient) Send(m *StepEndReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *workerStepEndClient) Recv() (*StepEndResp, error) {
	m := new(StepEndResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *workerClient) ControlTask(ctx context.Context, in *ControlTaskReq, opts ...grpc.CallOption) (*ControlTaskResp, error) {
	out := new(ControlTaskResp)
	err := c.cc.Invoke(ctx, "/master.Worker/ControlTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) SaveGraph(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error) {
	out := new(GraphPersistenceResp)
	err := c.cc.Invoke(ctx, "/master.Worker/SaveGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) WriteDisk(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error) {
	out := new(GraphPersistenceResp)
	err := c.cc.Invoke(ctx, "/master.Worker/WriteDisk", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) ReadGraph(ctx context.Context, in *GraphPersistenceReq, opts ...grpc.CallOption) (*GraphPersistenceResp, error) {
	out := new(GraphPersistenceResp)
	err := c.cc.Invoke(ctx, "/master.Worker/ReadGraph", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) GetWorkerStatInfo(ctx context.Context, in *WorkerStatInfoReq, opts ...grpc.CallOption) (*WorkerStatInfoResp, error) {
	out := new(WorkerStatInfoResp)
	err := c.cc.Invoke(ctx, "/master.Worker/GetWorkerStatInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) SettingAction(ctx context.Context, opts ...grpc.CallOption) (Worker_SettingActionClient, error) {
	stream, err := c.cc.NewStream(ctx, &Worker_ServiceDesc.Streams[3], "/master.Worker/SettingAction", opts...)
	if err != nil {
		return nil, err
	}
	x := &workerSettingActionClient{stream}
	return x, nil
}

type Worker_SettingActionClient interface {
	Send(*SettingActionReq) error
	Recv() (*SettingActionResp, error)
	grpc.ClientStream
}

type workerSettingActionClient struct {
	grpc.ClientStream
}

func (x *workerSettingActionClient) Send(m *SettingActionReq) error {
	return x.ClientStream.SendMsg(m)
}

func (x *workerSettingActionClient) Recv() (*SettingActionResp, error) {
	m := new(SettingActionResp)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *workerClient) RuntimeAction(ctx context.Context, in *RuntimeActionReq, opts ...grpc.CallOption) (*RuntimeActionResp, error) {
	out := new(RuntimeActionResp)
	err := c.cc.Invoke(ctx, "/master.Worker/RuntimeAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkerServer is the server API for Worker service.
// All implementations must embed UnimplementedWorkerServer
// for forward compatibility
type WorkerServer interface {
	SayHelloPeer(context.Context, *HelloPeerReq) (*HelloPeerResp, error)
	Scatter(Worker_ScatterServer) error
	LoadAction(Worker_LoadActionServer) error
	GetEdges(context.Context, *GetEdgesReq) (*GetEdgesResp, error)
	GetVertex(context.Context, *GetVertexReq) (*GetVertexResp, error)
	DeleteGraph(context.Context, *DeleteGraphReq) (*DeleteGraphResp, error)
	StepEnd(Worker_StepEndServer) error
	ControlTask(context.Context, *ControlTaskReq) (*ControlTaskResp, error)
	SaveGraph(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error)
	WriteDisk(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error)
	ReadGraph(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error)
	GetWorkerStatInfo(context.Context, *WorkerStatInfoReq) (*WorkerStatInfoResp, error)
	SettingAction(Worker_SettingActionServer) error
	RuntimeAction(context.Context, *RuntimeActionReq) (*RuntimeActionResp, error)
	mustEmbedUnimplementedWorkerServer()
}

// UnimplementedWorkerServer must be embedded to have forward compatible implementations.
type UnimplementedWorkerServer struct {
}

func (UnimplementedWorkerServer) SayHelloPeer(context.Context, *HelloPeerReq) (*HelloPeerResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SayHelloPeer not implemented")
}
func (UnimplementedWorkerServer) Scatter(Worker_ScatterServer) error {
	return status.Errorf(codes.Unimplemented, "method Scatter not implemented")
}
func (UnimplementedWorkerServer) LoadAction(Worker_LoadActionServer) error {
	return status.Errorf(codes.Unimplemented, "method LoadAction not implemented")
}
func (UnimplementedWorkerServer) GetEdges(context.Context, *GetEdgesReq) (*GetEdgesResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEdges not implemented")
}
func (UnimplementedWorkerServer) GetVertex(context.Context, *GetVertexReq) (*GetVertexResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVertex not implemented")
}
func (UnimplementedWorkerServer) DeleteGraph(context.Context, *DeleteGraphReq) (*DeleteGraphResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGraph not implemented")
}
func (UnimplementedWorkerServer) StepEnd(Worker_StepEndServer) error {
	return status.Errorf(codes.Unimplemented, "method StepEnd not implemented")
}
func (UnimplementedWorkerServer) ControlTask(context.Context, *ControlTaskReq) (*ControlTaskResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ControlTask not implemented")
}
func (UnimplementedWorkerServer) SaveGraph(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SaveGraph not implemented")
}
func (UnimplementedWorkerServer) WriteDisk(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteDisk not implemented")
}
func (UnimplementedWorkerServer) ReadGraph(context.Context, *GraphPersistenceReq) (*GraphPersistenceResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadGraph not implemented")
}
func (UnimplementedWorkerServer) GetWorkerStatInfo(context.Context, *WorkerStatInfoReq) (*WorkerStatInfoResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerStatInfo not implemented")
}
func (UnimplementedWorkerServer) SettingAction(Worker_SettingActionServer) error {
	return status.Errorf(codes.Unimplemented, "method SettingAction not implemented")
}
func (UnimplementedWorkerServer) RuntimeAction(context.Context, *RuntimeActionReq) (*RuntimeActionResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RuntimeAction not implemented")
}
func (UnimplementedWorkerServer) mustEmbedUnimplementedWorkerServer() {}

// UnsafeWorkerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to WorkerServer will
// result in compilation errors.
type UnsafeWorkerServer interface {
	mustEmbedUnimplementedWorkerServer()
}

func RegisterWorkerServer(s grpc.ServiceRegistrar, srv WorkerServer) {
	s.RegisterService(&Worker_ServiceDesc, srv)
}

func _Worker_SayHelloPeer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HelloPeerReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).SayHelloPeer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/SayHelloPeer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).SayHelloPeer(ctx, req.(*HelloPeerReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_Scatter_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WorkerServer).Scatter(&workerScatterServer{stream})
}

type Worker_ScatterServer interface {
	Send(*ScatterResp) error
	Recv() (*ScatterReq, error)
	grpc.ServerStream
}

type workerScatterServer struct {
	grpc.ServerStream
}

func (x *workerScatterServer) Send(m *ScatterResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *workerScatterServer) Recv() (*ScatterReq, error) {
	m := new(ScatterReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Worker_LoadAction_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WorkerServer).LoadAction(&workerLoadActionServer{stream})
}

type Worker_LoadActionServer interface {
	Send(*LoadActionResp) error
	Recv() (*LoadActionReq, error)
	grpc.ServerStream
}

type workerLoadActionServer struct {
	grpc.ServerStream
}

func (x *workerLoadActionServer) Send(m *LoadActionResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *workerLoadActionServer) Recv() (*LoadActionReq, error) {
	m := new(LoadActionReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Worker_GetEdges_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEdgesReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetEdges(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/GetEdges",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetEdges(ctx, req.(*GetEdgesReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_GetVertex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVertexReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetVertex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/GetVertex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetVertex(ctx, req.(*GetVertexReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_DeleteGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGraphReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).DeleteGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/DeleteGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).DeleteGraph(ctx, req.(*DeleteGraphReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_StepEnd_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WorkerServer).StepEnd(&workerStepEndServer{stream})
}

type Worker_StepEndServer interface {
	Send(*StepEndResp) error
	Recv() (*StepEndReq, error)
	grpc.ServerStream
}

type workerStepEndServer struct {
	grpc.ServerStream
}

func (x *workerStepEndServer) Send(m *StepEndResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *workerStepEndServer) Recv() (*StepEndReq, error) {
	m := new(StepEndReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Worker_ControlTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ControlTaskReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).ControlTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/ControlTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).ControlTask(ctx, req.(*ControlTaskReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_SaveGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GraphPersistenceReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).SaveGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/SaveGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).SaveGraph(ctx, req.(*GraphPersistenceReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_WriteDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GraphPersistenceReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).WriteDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/WriteDisk",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).WriteDisk(ctx, req.(*GraphPersistenceReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_ReadGraph_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GraphPersistenceReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).ReadGraph(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/ReadGraph",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).ReadGraph(ctx, req.(*GraphPersistenceReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_GetWorkerStatInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WorkerStatInfoReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetWorkerStatInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/GetWorkerStatInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetWorkerStatInfo(ctx, req.(*WorkerStatInfoReq))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_SettingAction_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(WorkerServer).SettingAction(&workerSettingActionServer{stream})
}

type Worker_SettingActionServer interface {
	Send(*SettingActionResp) error
	Recv() (*SettingActionReq, error)
	grpc.ServerStream
}

type workerSettingActionServer struct {
	grpc.ServerStream
}

func (x *workerSettingActionServer) Send(m *SettingActionResp) error {
	return x.ServerStream.SendMsg(m)
}

func (x *workerSettingActionServer) Recv() (*SettingActionReq, error) {
	m := new(SettingActionReq)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Worker_RuntimeAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RuntimeActionReq)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).RuntimeAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/master.Worker/RuntimeAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).RuntimeAction(ctx, req.(*RuntimeActionReq))
	}
	return interceptor(ctx, in, info, handler)
}

// Worker_ServiceDesc is the grpc.ServiceDesc for Worker service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Worker_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "master.Worker",
	HandlerType: (*WorkerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SayHelloPeer",
			Handler:    _Worker_SayHelloPeer_Handler,
		},
		{
			MethodName: "GetEdges",
			Handler:    _Worker_GetEdges_Handler,
		},
		{
			MethodName: "GetVertex",
			Handler:    _Worker_GetVertex_Handler,
		},
		{
			MethodName: "DeleteGraph",
			Handler:    _Worker_DeleteGraph_Handler,
		},
		{
			MethodName: "ControlTask",
			Handler:    _Worker_ControlTask_Handler,
		},
		{
			MethodName: "SaveGraph",
			Handler:    _Worker_SaveGraph_Handler,
		},
		{
			MethodName: "WriteDisk",
			Handler:    _Worker_WriteDisk_Handler,
		},
		{
			MethodName: "ReadGraph",
			Handler:    _Worker_ReadGraph_Handler,
		},
		{
			MethodName: "GetWorkerStatInfo",
			Handler:    _Worker_GetWorkerStatInfo_Handler,
		},
		{
			MethodName: "RuntimeAction",
			Handler:    _Worker_RuntimeAction_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Scatter",
			Handler:       _Worker_Scatter_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "LoadAction",
			Handler:       _Worker_LoadAction_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StepEnd",
			Handler:       _Worker_StepEnd_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "SettingAction",
			Handler:       _Worker_SettingAction_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "worker.proto",
}
