/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v2_2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AwsSdkTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes;
    private boolean useMessagingPropagator;
    private boolean recordIndividualHttpError;
    private boolean useXrayPropagator = true;
    private boolean messagingReceiveInstrumentationEnabled;

    AwsSdkTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setCapturedHeaders(Collection<String> capturedHeaders) {
        this.capturedHeaders = new ArrayList<String>(capturedHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setUseConfiguredPropagatorForMessaging(boolean useMessagingPropagator) {
        this.useMessagingPropagator = useMessagingPropagator;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setRecordIndividualHttpError(boolean recordIndividualHttpError) {
        this.recordIndividualHttpError = recordIndividualHttpError;
        return this;
    }

    @CanIgnoreReturnValue
    AwsSdkTelemetryBuilder setUseXrayPropagator(boolean useMessagingPropagator) {
        this.useXrayPropagator = useMessagingPropagator;
        return this;
    }

    @CanIgnoreReturnValue
    public AwsSdkTelemetryBuilder setMessagingReceiveInstrumentationEnabled(boolean messagingReceiveInstrumentationEnabled) {
        this.messagingReceiveInstrumentationEnabled = messagingReceiveInstrumentationEnabled;
        return this;
    }

    public AwsSdkTelemetry build() {
        return new AwsSdkTelemetry(this.openTelemetry, this.capturedHeaders, this.captureExperimentalSpanAttributes, this.useMessagingPropagator, this.useXrayPropagator, this.recordIndividualHttpError, this.messagingReceiveInstrumentationEnabled);
    }
}

