/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.Publisher;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.provider.AbstractInternalRegister;
import com.alipay.sofa.registry.client.task.TaskEvent;
import com.alipay.sofa.registry.client.task.Worker;
import com.alipay.sofa.registry.core.model.DataBox;
import com.alipay.sofa.registry.core.model.PublisherRegister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

public class DefaultPublisher
extends AbstractInternalRegister
implements Publisher {
    private final String REGIST_ID;
    private PublisherRegistration registration;
    private Worker worker;
    private Collection<String> dataList;
    private RegistryClientConfig config;

    DefaultPublisher(PublisherRegistration registration, Worker worker, RegistryClientConfig config) {
        this.registration = registration;
        this.worker = worker;
        this.config = config;
        this.REGIST_ID = UUID.randomUUID().toString();
    }

    @Override
    public void republish(String ... data) {
        if (this.isRefused()) {
            throw new IllegalStateException("Publisher is refused by server. Try to check your configuration.");
        }
        if (!this.isEnabled()) {
            throw new IllegalStateException("Unregistered publisher can not be reused.");
        }
        this.writeLock.lock();
        try {
            if (null != data) {
                this.dataList = Arrays.asList(data);
            }
            this.getPubVersion().incrementAndGet();
            this.setTimestamp(System.currentTimeMillis());
            this.waitToSync();
        }
        finally {
            this.writeLock.unlock();
        }
        this.worker.schedule(new TaskEvent(this));
    }

    @Override
    public void unregister() {
        if (this.isEnabled()) {
            super.unregister();
            this.worker.schedule(new TaskEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublisherRegister assembly() {
        PublisherRegister register;
        this.readLock.lock();
        try {
            register = new PublisherRegister();
            register.setRegistId(this.REGIST_ID);
            this.setAttributes(register, this.registration, this.config);
            this.setAuthSignature(register);
            if (this.isEnabled()) {
                register.setEventType("REGISTER");
                if (null != this.dataList) {
                    ArrayList<DataBox> dataBoxes = new ArrayList<DataBox>();
                    for (String data : this.dataList) {
                        dataBoxes.add(new DataBox(data));
                    }
                    register.setDataList(dataBoxes);
                }
            } else {
                register.setEventType("UNREGISTER");
            }
        }
        finally {
            this.readLock.unlock();
        }
        return register;
    }

    @Override
    public String getDataId() {
        return this.registration.getDataId();
    }

    @Override
    public String getGroup() {
        return this.registration.getGroup();
    }

    @Override
    public String getRegistId() {
        return this.REGIST_ID;
    }

    @Override
    public String toString() {
        return "DefaultPublisher{registration=" + this.registration + '}' + super.toString();
    }
}

