/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.cache;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.inlong.audit.service.config.Configuration;
import org.apache.inlong.audit.service.entities.JdbcConfig;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.utils.AuditUtils;
import org.apache.inlong.audit.service.utils.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayCache
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DayCache.class);
    private static volatile DayCache dayCache = null;
    private DataSource dataSource;

    private DayCache() {
        this.createDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DayCache getInstance() {
        if (dayCache != null) return dayCache;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (dayCache != null) return dayCache;
            dayCache = new DayCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dayCache;
        }
    }

    public List<StatData> getData(String startTime, String endTime, String inlongGroupId, String inlongStreamId, String auditId) {
        LinkedList<StatData> result = new LinkedList<StatData>();
        String querySQL = Configuration.getInstance().get("mysql.query.day.sql", "select log_ts,inlong_group_id,inlong_stream_id,audit_id,audit_tag,count AS cnt,size,delay from audit_data_day where log_ts >= ? AND log_ts < ? AND inlong_group_id=? AND inlong_stream_id=? AND audit_id =? ");
        ArrayList<String> paramList = new ArrayList<String>();
        if ("*".equals(inlongStreamId)) {
            querySQL = AuditUtils.removeStreamIdCondition((String)querySQL);
            querySQL = AuditUtils.removeStreamIdColumn((String)querySQL);
            paramList.add(startTime);
            paramList.add(endTime);
            paramList.add(inlongGroupId);
            paramList.add(auditId);
        } else {
            paramList.add(startTime);
            paramList.add(endTime);
            paramList.add(inlongGroupId);
            paramList.add(inlongStreamId);
            paramList.add(auditId);
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement pstat = connection.prepareStatement(querySQL);){
            if (connection.isClosed()) {
                this.createDataSource();
            }
            for (int i = 0; i < paramList.size(); ++i) {
                pstat.setString(i + 1, (String)paramList.get(i));
            }
            try (ResultSet resultSet = pstat.executeQuery();){
                while (resultSet.next()) {
                    StatData data = new StatData();
                    data.setLogTs(resultSet.getString("log_ts"));
                    data.setInlongGroupId(resultSet.getString("inlong_group_id"));
                    data.setAuditId(resultSet.getString("audit_id"));
                    data.setAuditTag(resultSet.getString("audit_tag"));
                    data.setCount(Long.valueOf(resultSet.getLong("cnt")));
                    data.setSize(Long.valueOf(resultSet.getLong("size")));
                    data.setDelay(Long.valueOf(resultSet.getLong("delay")));
                    if ("*".equals(inlongStreamId)) {
                        data.setInlongStreamId("*");
                    } else {
                        data.setInlongStreamId(resultSet.getString("inlong_stream_id"));
                    }
                    result.add(data);
                }
            }
            catch (SQLException sqlException) {
                LOGGER.error("Query has SQL exception! ", (Throwable)sqlException);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Query has exception! ", (Throwable)exception);
        }
        return "*".equals(inlongStreamId) ? AuditUtils.aggregateStatData(result, (String)inlongStreamId) : result;
    }

    private void createDataSource() {
        JdbcConfig jdbcConfig = JdbcUtils.buildMysqlConfig();
        HikariConfig config = new HikariConfig();
        config.setDriverClassName(jdbcConfig.getDriverClass());
        config.setJdbcUrl(jdbcConfig.getJdbcUrl());
        config.setUsername(jdbcConfig.getUserName());
        config.setPassword(jdbcConfig.getPassword());
        config.setConnectionTimeout((long)Configuration.getInstance().get("datasource.connection.timeout.ms", 300000));
        config.addDataSourceProperty("cachePrepStmts", (Object)Configuration.getInstance().get("cache.prep.stmts", true));
        config.addDataSourceProperty("prepStmtCacheSize", (Object)Configuration.getInstance().get("prep.stmt.cache.size", 250));
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)Configuration.getInstance().get("prep.stmt.cache.sql.limit", 2048));
        config.setMaximumPoolSize(Configuration.getInstance().get("datasource.pool.size", 2));
        this.dataSource = new HikariDataSource(config);
    }

    @Override
    public void close() throws Exception {
    }
}

